/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.control;

import com.owon.uppersoft.dso.control.IntermediateMouseAdapter;
import com.owon.uppersoft.dso.control.LeftScreenGesture;
import com.owon.uppersoft.dso.control.RightScreenGesture;
import com.owon.uppersoft.dso.function.MarkCursorControl;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.mode.control.TimeControl;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.helper.ETV_TrgConditon;
import com.owon.uppersoft.dso.view.ChartScreen;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.ViewChart;
import com.owon.uppersoft.dso.wf.ChartScreenSelectModel;
import com.owon.uppersoft.dso.wf.ON_WF_Iterator;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JPanel;

public class ChartScreenMouseGesture
extends MouseAdapter {
    private boolean left = false;
    private boolean top = false;
    private boolean centre = false;
    private boolean right = false;
    private Point loc0;
    private ViewChart vc;
    private JPanel pa;
    private WaveFormManager wfm;
    private TimeControl tc;
    private TriggerControl tgc;
    private MarkCursorControl mcctr;
    private ControlManager cm;
    private ChartScreen cs;
    private DataHouse dh;
    private MainWindow mw;
    private RightScreenGesture rsg;
    private LeftScreenGesture lsg;
    private ETV_TrgConditon etv_over = null;
    private ChartScreenSelectModel ccsm;
    private IntermediateMouseAdapter ima;

    public RightScreenGesture getRightScreenGesture() {
        return this.rsg;
    }

    public ChartScreenMouseGesture(MainWindow mainWindow, ViewChart viewChart, DataHouse dataHouse, JPanel jPanel, ChartScreen chartScreen) {
        this.mw = mainWindow;
        this.vc = viewChart;
        this.cs = chartScreen;
        this.dh = dataHouse;
        this.ccsm = chartScreen.getChartScreenSelectModel();
        this.pa = jPanel;
        this.cm = dataHouse.controlManager;
        this.rsg = new RightScreenGesture(this.cm.getCoreControl().getTriggerLevelDelegate(), this.ccsm);
        this.lsg = new LeftScreenGesture(this.ccsm);
        this.wfm = dataHouse.getWaveFormManager();
        this.tc = this.cm.getTimeControl();
        this.tgc = this.cm.getTriggerControl();
        this.loc0 = new Point();
        this.ima = new IntermediateMouseAdapter(this);
        jPanel.addMouseListener(this.ima);
        jPanel.addMouseMotionListener(this.ima);
        jPanel.addMouseWheelListener(this.ima);
        this.mcctr = this.cm.mcctr;
        this.mcctr.acceptImporter(viewChart, dataHouse);
    }

    public void enableGesture(boolean bl) {
        this.ima.enableGesture(bl);
    }

    public void resetPressed() {
        this.top = false;
        this.left = false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Rectangle rectangle;
        double d;
        double d2 = (double)mouseEvent.getX() / DataHouse.xRate;
        if (this.mcctr.checkButton((int)d2, (int)(d = (double)mouseEvent.getY() / DataHouse.yRate), rectangle = this.vc.getLocInfo())) {
            if (mouseEvent.getModifiers() == 16) {
                this.mcctr.toogle();
            } else {
                this.cm.getDockControl().dockDialogQuickOpenHide("M.Mark.Name");
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.loc0.x = mouseEvent.getX();
        this.loc0.y = mouseEvent.getY();
        this.loc0.x = (int)((double)this.loc0.x / DataHouse.xRate);
        this.loc0.y = (int)((double)this.loc0.y / DataHouse.yRate);
        if (this.left) {
            this.lsg.mousePressed(this.vc, this.wfm);
        }
        if (this.right) {
            this.rsg.mousePressed(this.vc, this.wfm);
        }
        if (this.top) {
            boolean bl = Platform.getControlApps().interComm.isTimeOperatableNTryGetDM();
            if (!bl) {
                return;
            }
            Rectangle rectangle = this.vc.getLocInfo();
            int n = rectangle.x + (rectangle.width >> 1) - this.tc.getHorizontalTriggerPosition();
            ON_WF_Iterator oN_WF_Iterator = this.wfm.on_wf_Iterator();
            while (oN_WF_Iterator.hasNext()) {
                int n2;
                WaveForm waveForm = oN_WF_Iterator.next();
                ETV_TrgConditon eTV_TrgConditon = this.tgc.getTrgConditonOrNull(waveForm.getChannelNumber());
                if (eTV_TrgConditon == null || this.loc0.x <= (n2 = n - (int)(eTV_TrgConditon.getTime_mS() / this.tc.getPixelTime_mS())) - 6 || this.loc0.x >= n2 + 6) continue;
                this.etv_over = eTV_TrgConditon;
                this.ccsm.setScreenSelectWFidx(waveForm.getChannelNumber());
                this.ccsm.setOnShowHtcDetail(true);
                this.vc.re_paint();
                return;
            }
        }
        if (this.centre && !this.mcctr.ison) {
            this.cm.pcs.firePropertyChange("TURN_ON_MARKBULLETIN", null, (Object)true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        ScreenContext screenContext = this.vc.getScreenContext();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Rectangle rectangle = this.vc.getLocInfo();
        n = (int)((double)n / DataHouse.xRate);
        n2 = (int)((double)n2 / DataHouse.yRate);
        if (this.left) {
            this.lsg.dragLeft(n, n2, screenContext, this.cs, this.mw, this.wfm, this.loc0, this.mcctr, true);
            this.lsg.mouseReleased(this.wfm);
        }
        if (this.right) {
            this.rsg.mouseReleased();
            this.rsg.dragRight(n, n2, screenContext.isScreenMode_3(), this.vc, this.mw, this.wfm, this.loc0, true, this.cm);
        }
        if (this.top) {
            this.dragTop(n, n2, true);
            if (this.etv_over != null) {
                this.etv_over = null;
                this.ccsm.setOnShowHtcDetail(false);
                this.ccsm.resetNoneSelect();
            } else {
                this.ccsm.setOnShowHtpDetail(false);
            }
        }
        this.vc.re_paint();
    }

    protected boolean isCommitImmediately() {
        return !this.dh.isOptimizeDragCommandSend();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        ScreenContext screenContext = this.vc.getScreenContext();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Rectangle rectangle = this.vc.getLocInfo();
        n = (int)((double)n / DataHouse.xRate);
        n2 = (int)((double)n2 / DataHouse.yRate);
        boolean bl = this.isCommitImmediately();
        if (this.left) {
            this.lsg.dragLeft(n, n2, screenContext, this.cs, this.mw, this.wfm, this.loc0, this.mcctr, true);
        } else if (this.top) {
            this.dragTop(n, n2, true);
        } else if (this.right) {
            this.rsg.dragRight(n, n2, screenContext.isScreenMode_3(), this.vc, this.mw, this.wfm, this.loc0, true, this.cm);
            this.loc0.y = Math.min(Math.max(this.loc0.y, rectangle.y), rectangle.y + rectangle.height - 1);
        } else if (this.centre) {
            this.dragCenter(n, n2);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Rectangle rectangle = this.vc.getLocInfo();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        n = (int)((double)n / DataHouse.xRate);
        n2 = (int)((double)n2 / DataHouse.yRate);
        this.right = false;
        this.ccsm.setRight(false);
        this.left = this.lsg.checkLeft(n, n2, rectangle, this.vc, this, this.wfm, this.left);
        if (this.left) {
            return;
        }
        this.right = this.rsg.checkRight(n, n2, rectangle, this.vc, this.dh, this, this.wfm);
        if (this.right) {
            return;
        }
        if (this.checkTop(n, n2, rectangle)) {
            return;
        }
        if (this.checkCentre(n, n2, rectangle)) {
            return;
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void dragCenter(int n, int n2) {
        this.mcctr.dragMarkCursor(n, n2);
        this.vc.re_paint();
    }

    private boolean checkCentre(int n, int n2, Rectangle rectangle) {
        int n3 = rectangle.x;
        int n4 = rectangle.x + rectangle.width;
        int n5 = rectangle.y;
        int n6 = rectangle.y + rectangle.height;
        if (n > n3 && n < n4 && n2 > n5 && n2 < n6) {
            if (this.mcctr.checkButton(n, n2, rectangle)) {
                this.cursor(12);
                return true;
            }
            ScreenContext screenContext = this.vc.getScreenContext();
            int n7 = this.mcctr.checkMark(screenContext.isScreenMode_3(), n, n2);
            this.centre = n7 != 0;
            this.cursor(n7);
        } else if (this.centre) {
            this.centre = false;
            this.cursor(0);
        }
        return this.centre;
    }

    private void dragTop(int n, int n2, boolean bl) {
        Rectangle rectangle = this.vc.getLocInfo();
        if (this.etv_over != null) {
            int n3 = this.ccsm.getScreenSelectWFidx();
            int n4 = rectangle.x + (rectangle.width >> 1) - this.tc.getHorizontalTriggerPosition();
            int n5 = Math.min(n4, n4 - n);
            this.etv_over.setTime_mS((double)n5 * this.tc.getPixelTime_mS());
            this.tgc.doSubmitTrgCondition(n3);
            this.cm.pcs.firePropertyChange("UpdateCondition", -1, n3);
            this.vc.re_paint();
            return;
        }
        this.ccsm.setOnShowHtpDetail(true);
        int n6 = rectangle.x + (rectangle.width >> 1) - n;
        this.tc.c_setHorizontalTriggerPosition(n6, bl);
        if (!this.cm.getZoomAssctr().isonAssistSet()) {
            this.cm.pcs.firePropertyChange("onHTPChanged", null, null);
        }
        this.cm.getZoomAssctr().updateZoomHtp();
        this.cm.mcctr.computeXValues();
        this.loc0.x = n;
        this.loc0.y = n2;
    }

    private boolean checkTop(int n, int n2, Rectangle rectangle) {
        if (this.dh.isHorTrgPosFrozen()) {
            this.top = false;
            return false;
        }
        if (this.cm.getZoomAssctr().isonAssistSet()) {
            this.top = false;
            return false;
        }
        if (n2 > 0 && n2 < rectangle.y) {
            this.top = true;
            this.cursor(10);
        } else if (this.top) {
            this.top = false;
            this.cursor(0);
        }
        return this.top;
    }

    public final void cursor(int n) {
        this.pa.setCursor(Cursor.getPredefinedCursor(n));
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        this.mw.getToolPane().getDetailPane().nextTimeBase(n);
    }
}

