/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.about;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.update.action.UpdateAction;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.pane.dock.widget.TitleBar;
import com.owon.uppersoft.vds.core.aspect.IBoard;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.core.pref.Config;
import com.owon.uppersoft.vds.core.pref.StaticPref;
import com.owon.uppersoft.vds.core.update.IUpdateAction;
import com.owon.uppersoft.vds.ui.layout.OneColumnLayout;
import com.owon.uppersoft.vds.ui.layout.OneRowLayout;
import com.owon.uppersoft.vds.ui.paint.LineDrawTool;
import com.owon.uppersoft.vds.ui.resource.SwingResourceManager;
import com.owon.uppersoft.vds.ui.widget.custom.CButton;
import com.owon.uppersoft.vds.ui.widget.custom.CLabel;
import com.owon.uppersoft.vds.ui.widget.custom.LButton;
import com.owon.uppersoft.vds.ui.window.ComponentMover;
import com.owon.uppersoft.vds.ui.window.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AboutDialog
implements Localizable {
    private static final int arcOut = 15;
    private static final int arcIn = 14;
    private static final int fw = 550;
    private static final int fh = 230;
    private JDialog frame;
    private ControlManager cm;
    private StaticPref pre;
    private CLabel title;
    private CButton updatebtn;
    private JLabel build;
    private JLabel version;
    private JLabel machine;
    private JLabel copyright;
    private JLabel weblb;
    private IBoard sc;
    private JLabel vslbl;
    private static AboutDialog instance;
    private IUpdateAction updateAct;

    public static void handleAboutInstance(Config config, ControlManager controlManager) {
        if (instance == null || !instance.getAboutDlg().isDisplayable()) {
            instance = new AboutDialog(Platform.getMainWindow(), config, controlManager);
            controlManager.getLocalizeCenter().addLocalizable(instance);
        } else {
            instance.getAboutDlg().toFront();
        }
    }

    public JDialog getAboutDlg() {
        return this.frame;
    }

    public AboutDialog(MainWindow mainWindow, Config config, ControlManager controlManager) {
        this.cm = controlManager;
        this.updateAct = UpdateAction.getUpdateAction();
        JFrame jFrame = mainWindow.getFrame();
        this.pre = config.getStaticPref();
        this.initialize(jFrame, controlManager);
        new ComponentMover(this.frame, this.frame);
        this.frame.setUndecorated(true);
        WindowUtil.cutCorners(this.frame, 15);
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    private void initialize(Window window, ControlManager controlManager) {
        ResourceBundle resourceBundle = I18nProvider.bundle();
        Font font = Define.def.snapshotfont_en;
        this.frame = new JDialog(window);
        this.frame.setType(Window.Type.UTILITY);
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                AboutDialog.this.close();
            }
        });
        JPanel jPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Define.def.CO_DockBorder);
                graphics2D.setStroke(Define.def.Stroke2);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.drawRoundRect(1, 1, n - 3, n2 - 3, 15, 15);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        };
        jPanel.setLayout(new BorderLayout(0, 0));
        this.frame.setContentPane(jPanel);
        this.frame.setDefaultCloseOperation(2);
        JPanel jPanel2 = new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setPaint(TitleBar.GradientTexturePaint);
                graphics2D.fillRoundRect(2, 2, n - 4, n2 + 14, 14, 14);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        };
        jPanel2.setLayout(new OneRowLayout(new Insets(5, 15, 5, 10), 0));
        new ComponentMover(this.frame, jPanel2);
        this.title = new CLabel();
        this.title.setPreferredSize(new Dimension(501, 30));
        ImageIcon imageIcon = SwingResourceManager.getIcon(AboutDialog.class, "/com/owon/uppersoft/dso/image/close.png");
        LButton lButton = new LButton();
        lButton.setIcon(imageIcon);
        lButton.setPressedIcon(LineDrawTool.getRolloverIcon(imageIcon));
        lButton.setPreferredSize(new Dimension(24, 24));
        lButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.this.close();
            }
        });
        jPanel2.add(this.title);
        jPanel2.add(lButton);
        JPanel jPanel3 = new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Define.def.style.CO_DockContainer);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.fillRoundRect(2, -14, n - 4, n2 + 14 - 2, 14, 14);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        };
        jPanel3.setLayout(new FlowLayout(0, 20, 10));
        JPanel jPanel4 = new JPanel();
        jPanel4.setOpaque(false);
        jPanel4.setLayout(new OneColumnLayout());
        jPanel4.setPreferredSize(new Dimension(550, 90));
        this.sc = controlManager.getSoftwareControl();
        Dimension dimension = new Dimension(275, 25);
        this.build = new JLabel();
        this.build.setFont(font);
        this.build.setPreferredSize(dimension);
        this.build.setForeground(Color.WHITE);
        jPanel4.add(this.build);
        this.version = new JLabel();
        this.version.setFont(font);
        this.version.setPreferredSize(dimension);
        this.version.setForeground(Color.WHITE);
        jPanel4.add(this.version);
        this.vslbl = new JLabel();
        this.vslbl.setFont(font);
        this.vslbl.setPreferredSize(dimension);
        this.vslbl.setForeground(Color.WHITE);
        jPanel4.add(this.vslbl);
        this.weblb = new JLabel(this.getWebsite());
        this.weblb.setFont(font);
        this.weblb.setForeground(Color.WHITE);
        this.weblb.setCursor(Cursor.getPredefinedCursor(12));
        this.weblb.setPreferredSize(new Dimension(550, 20));
        this.weblb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                String string = AboutDialog.this.pre.getWebsite();
                try {
                    Desktop.getDesktop().browse(new URI(string));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.updatebtn = new CButton();
        this.updatebtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = AboutDialog.this.pre.getUpdateServer();
                try {
                    Desktop.getDesktop().browse(new URI(string));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        jPanel3.add(jPanel4);
        jPanel3.add(this.weblb);
        if (this.pre.isOwon()) {
            jPanel3.add(this.updatebtn);
        }
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        this.frame.setSize(550, 230);
        this.frame.setLocationRelativeTo(window);
        this.localize(resourceBundle);
    }

    public void close() {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
        instance = null;
    }

    private String getWebsite() {
        String string = this.pre.getWebsite();
        return "<html><font><u>" + string + "<u></font></html>";
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        if (this.frame == null) {
            return;
        }
        String string = String.format("%s (%s)", this.pre.getVersionId(), this.pre.getInternalVersionId());
        try {
            File file = new File(Platform.APP_DIR, "version.txt");
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.title.setText(resourceBundle.getString("About.Name"));
        this.build.setText(String.format("%s  %s  %s", this.pre.getManufacturerId().toUpperCase(), this.cm.getMachine().name(), string));
        this.version.setText(String.format("%s %s", resourceBundle.getString("About.Version"), this.sc.getBoardVersion()));
        this.vslbl.setText(String.format("%s %s", resourceBundle.getString("About.SN"), this.sc.getBoardSeries()));
        this.weblb.setText(this.getWebsite());
        this.updatebtn.setText(resourceBundle.getString("Action.Update"));
    }
}

