/*
 * Decompiled with CFR 0.152.
 */
package shared.mvc;

import java.util.Observable;
import java.util.function.Consumer;

public class ModelValue<T>
extends Observable {
    private T value;
    protected final String name;

    public ModelValue(String name, T initialValue) {
        this.value = initialValue;
        this.name = name;
    }

    public void addListener(Consumer<T> listener) {
        this.addObserver((o, arg) -> listener.accept(this.getValue()));
    }

    public void addListener(Runnable listener) {
        this.addObserver((o, arg) -> listener.run());
    }

    public void setValue(T value) {
        if (value == null || this.value == null ? value == this.value : this.value.equals(value)) {
            return;
        }
        this.value = value;
        this.callObservers();
    }

    public void callObservers() {
        this.setChanged();
        this.notifyObservers();
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        return this.name;
    }

    public static class ModelValueBoolean
    extends ModelValue<Boolean> {
        public ModelValueBoolean(String name, Boolean initialValue) {
            super(name, initialValue);
        }
    }

    public static class ModelValueInt
    extends ModelValue<Integer> {
        protected final boolean isBounded;
        protected final int min;
        protected final int max;
        protected final int step;

        public ModelValueInt(String name, int initialValue) {
            super(name, initialValue);
            this.isBounded = false;
            this.max = 0;
            this.min = 0;
            this.step = 0;
        }

        public ModelValueInt(String name, int initialValue, int step, int min, int max) {
            super(name, initialValue);
            this.isBounded = true;
            this.min = min;
            this.max = max;
            this.step = step;
        }

        public int getMax() {
            return this.max;
        }

        public int getMin() {
            return this.min;
        }

        public int getStep() {
            return this.step;
        }

        @Override
        public void setValue(Integer value) {
            if (this.isBounded() && (value < this.min || value > this.max)) {
                throw new IllegalStateException("New value of '" + this.name + "' '" + value + "' is outside of bounds <" + this.min + ", " + this.max + ">");
            }
            super.setValue(value);
        }

        public boolean isBounded() {
            return this.isBounded;
        }
    }
}

