/*
 * Decompiled with CFR 0.152.
 */
package shared.mvc;

import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import shared.mvc.ModelValue;

public class MVCController {
    protected boolean disableViewListeners = false;

    public <T> MVCController(ViewAddChangeListener<T> viewAddChangeListener, Consumer<T> viewSetValue, ModelValue<T> model) {
        this(viewAddChangeListener, viewSetValue, model, val -> val, val -> val);
    }

    public <VIEW_T, MODEL_T> MVCController(ViewAddChangeListener<VIEW_T> viewAddChangeListener, Consumer<VIEW_T> viewSetValue, ModelValue<MODEL_T> model, Function<VIEW_T, MODEL_T> conversionViewToModel, Function<MODEL_T, VIEW_T> conversionModelToView) {
        viewAddChangeListener.addChangeListener(newViewValue -> this.updateModelValue(() -> model.setValue(conversionViewToModel.apply(newViewValue))));
        model.addListener(() -> this.updateView(() -> viewSetValue.accept(conversionModelToView.apply(model.getValue()))));
        this.sync(model);
    }

    public MVCController(JCheckBox checkbox, ModelValue.ModelValueBoolean model) {
        checkbox.addChangeListener(e -> this.updateModelValue(() -> model.setValue(checkbox.isSelected())));
        model.addListener(() -> this.updateView(() -> checkbox.setSelected((Boolean)model.getValue())));
        this.sync(model);
    }

    public MVCController(JSlider slider, ModelValue.ModelValueInt model) {
        this(slider, model, (Integer val) -> val, (T val) -> val);
    }

    public <T> MVCController(JSlider slider, ModelValue<T> model, Function<Integer, T> conversionViewToModel, Function<T, Integer> conversionModelToView) {
        slider.addChangeListener(e -> this.updateModelValue(() -> model.setValue(conversionViewToModel.apply(slider.getValue()))));
        model.addListener(() -> this.updateView(() -> slider.setValue((Integer)conversionModelToView.apply(model.getValue()))));
        this.sync(model);
    }

    public <T> MVCController(JSpinner spinner, ModelValue<T> model, Function<Object, T> conversionViewToModel, Function<T, Object> conversionModelToView) {
        spinner.addChangeListener(e -> this.updateModelValue(() -> model.setValue(conversionViewToModel.apply(spinner.getValue()))));
        model.addListener(() -> this.updateView(() -> spinner.setValue(conversionModelToView.apply(model.getValue()))));
        this.sync(model);
    }

    public <T> MVCController(JComboBox<T> comboBox, ModelValue<T> model, Function<Object, T> conversionViewToModel, Function<T, Object> conversionModelToView) {
        comboBox.addActionListener(e -> this.updateModelValue(() -> model.setValue(conversionViewToModel.apply(comboBox.getSelectedItem()))));
        model.addListener(() -> this.updateView(() -> comboBox.setSelectedItem(conversionModelToView.apply(model.getValue()))));
        this.sync(model);
    }

    public <T> MVCController(JComboBox<T> comboBox, ModelValue<T> model) {
        this(comboBox, model, (Object val) -> val, (T val) -> val);
    }

    protected void sync(ModelValue<?> val) {
        val.callObservers();
    }

    protected void updateView(Runnable viewChangedCall) {
        SwingUtilities.invokeLater(() -> {
            this.disableViewListeners = true;
            try {
                try {
                    viewChangedCall.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.disableViewListeners = false;
                }
            }
            finally {
                this.disableViewListeners = false;
            }
        });
    }

    protected void _updateModelValueCall(Runnable updateModelValueCall) {
        if (!this.disableViewListeners) {
            updateModelValueCall.run();
        }
    }

    protected void updateModelValue(Runnable updateModelValueCall) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this._updateModelValueCall(updateModelValueCall));
        } else {
            this._updateModelValueCall(updateModelValueCall);
        }
    }

    public static interface ViewAddChangeListener<T> {
        public void addChangeListener(Consumer<T> var1);
    }
}

