/*
 * Decompiled with CFR 0.152.
 */
package jspectrumanalyzer.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.swing.JPanel;
import jspectrumanalyzer.core.DatasetSpectrum;
import jspectrumanalyzer.core.EMA;
import jspectrumanalyzer.ui.ColorPalette;
import jspectrumanalyzer.ui.GraphicsToolkit;
import jspectrumanalyzer.ui.HotIronBluePalette;
import org.jfree.chart.ChartPanel;

public class WaterfallPlot
extends JPanel {
    private static final long serialVersionUID = 3249110968962287324L;
    private BufferedImage[] bufferedImages = new BufferedImage[2];
    private int chartXOffset = 0;
    private int chartWidth = 100;
    private boolean displayMarker = false;
    private double displayMarkerFrequency = 0.0;
    private int displayMarkerX = 0;
    private int drawIndex = 0;
    private float[] drawMaxBuffer;
    private EMA fps = new EMA(3);
    private int fpsRenderedFrames = 0;
    private long lastFPSRecalculated = 0L;
    private DatasetSpectrum lastSpectrum = null;
    private ColorPalette palette = new HotIronBluePalette();
    private Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 1.0f);
    private String renderingInfo = "";
    private int screenWidth;
    private double spectrumPaletteSize = 65.0;
    private double spectrumPaletteStart = -90.0;
    private String[] statusMessage = new String[4];
    private EMA newDataTimeEMA = new EMA(100);
    Rectangle2D stringBounds;
    private volatile long drawingTimeSum = 0L;
    private volatile int drawingCounter = 0;

    public WaterfallPlot(ChartPanel chartPanel, int maxHeight) {
        this.setPreferredSize(new Dimension(100, 200));
        this.setMinimumSize(new Dimension(100, 200));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                WaterfallPlot.this.setHistorySize(WaterfallPlot.this.getHeight());
            }
        });
        this.screenWidth = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        this.drawMaxBuffer = new float[this.screenWidth];
        this.bufferedImages[0] = GraphicsToolkit.createAcceleratedImageOpaque(this.screenWidth, maxHeight);
        this.bufferedImages[1] = GraphicsToolkit.createAcceleratedImageOpaque(this.screenWidth, maxHeight);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                WaterfallPlot.this.displayMarker = false;
                int x = e.getX();
                if (x < WaterfallPlot.this.chartXOffset || x > WaterfallPlot.this.chartXOffset + WaterfallPlot.this.chartWidth) {
                    return;
                }
                double freq = WaterfallPlot.this.translateChartXToFrequency(x - WaterfallPlot.this.chartXOffset);
                if (freq != -1.0) {
                    WaterfallPlot.this.displayMarker = true;
                    WaterfallPlot.this.displayMarkerFrequency = freq;
                    WaterfallPlot.this.displayMarkerX = x;
                }
                WaterfallPlot.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                WaterfallPlot.this.displayMarker = false;
            }
        });
    }

    public synchronized void addNewData(DatasetSpectrum spectrum) {
        long start = System.nanoTime();
        int size = spectrum.spectrumLength();
        double startFreq = (double)spectrum.getFreqStartMHz() * 1000000.0;
        double freqRange = (double)(spectrum.getFreqStopMHz() - spectrum.getFreqStartMHz()) * 1000000.0;
        double width = this.bufferedImages[0].getWidth();
        double spectrumPalleteMax = this.spectrumPaletteStart + this.spectrumPaletteSize;
        this.lastSpectrum = spectrum;
        BufferedImage previousImage = this.bufferedImages[this.drawIndex];
        this.drawIndex = (this.drawIndex + 1) % 2;
        Graphics2D g = this.bufferedImages[this.drawIndex].createGraphics();
        g.drawImage((Image)previousImage, 0, 1, null);
        g.setColor(Color.black);
        g.fillRect(0, 0, (int)width, 1);
        float binWidth = (float)((double)spectrum.getFFTBinSizeHz() / freqRange * width);
        this.rect.x = 0.0f;
        this.rect.y = 0.0f;
        this.rect.height = 0.0f;
        this.rect.width = binWidth;
        float minimumValueDrawBuffer = -150.0f;
        Arrays.fill(this.drawMaxBuffer, minimumValueDrawBuffer);
        double widthDivSize = width / (double)size;
        double inverseSpectrumPaletteSize = 1.0 / this.spectrumPaletteSize;
        double spectrumPaletteStartDivSpectrumPaletteSize = this.spectrumPaletteStart / this.spectrumPaletteSize;
        int i = 0;
        while (i < size) {
            int pixelX;
            double power = spectrum.getPower(i);
            double percentagePower = 0.0;
            if (power > this.spectrumPaletteStart) {
                percentagePower = power < spectrumPalleteMax ? power * inverseSpectrumPaletteSize - spectrumPaletteStartDivSpectrumPaletteSize : 1.0;
            }
            int n = (pixelX = (int)Math.round(widthDivSize * (double)i)) >= this.drawMaxBuffer.length ? this.drawMaxBuffer.length - 1 : (pixelX = pixelX < 0 ? 0 : pixelX);
            if (percentagePower > (double)this.drawMaxBuffer[pixelX]) {
                this.drawMaxBuffer[pixelX] = (float)percentagePower;
            }
            ++i;
        }
        Color lastValidColor = this.palette.getColor(0);
        int x = 0;
        while (x < this.drawMaxBuffer.length) {
            Color color;
            if (this.drawMaxBuffer[x] == minimumValueDrawBuffer) {
                color = lastValidColor;
            } else {
                lastValidColor = color = this.palette.getColorNormalized(this.drawMaxBuffer[x]);
            }
            this.rect.x = x;
            g.setColor(color);
            g.draw(this.rect);
            ++x;
        }
        this.renderingInfo = String.format("RBW %.1fkHz / FFT bins: %d%s / %.1ffps", this.lastSpectrum == null ? 0.0 : (double)this.lastSpectrum.getFFTBinSizeHz() / 1000.0, size >= 10000 ? size / 1000 : size, size >= 10000 ? "k" : "", this.fps.getEma());
        ++this.fpsRenderedFrames;
        if (System.currentTimeMillis() - this.lastFPSRecalculated > 1000L) {
            double rawfps = (double)this.fpsRenderedFrames / (((double)System.currentTimeMillis() - (double)this.lastFPSRecalculated) / 1000.0);
            this.fps.addNewValue(rawfps);
            this.lastFPSRecalculated = System.currentTimeMillis();
            this.fpsRenderedFrames = 0;
        }
        g.dispose();
    }

    public void drawScale(Graphics2D g, int x, int y, int w, int h) {
        g = (Graphics2D)g.create(x, y, w, h);
        int step = 3;
        int i = 0;
        while (i < h) {
            Color c = this.palette.getColorNormalized(1.0 - (double)i / (double)h);
            g.setColor(c);
            g.fillRect(0, i, w, step);
            i += step;
        }
        int thickness = 2;
        g.setColor(Color.darkGray);
        g.fillRect(0, 0, w, thickness);
        g.fillRect(w - thickness, 0, thickness, h);
        g.fillRect(0, h - thickness, w, thickness);
        g.dispose();
    }

    public int getHistorySize() {
        return this.bufferedImages[0].getHeight();
    }

    public double getSpectrumPaletteSize() {
        return this.spectrumPaletteSize;
    }

    public double getSpectrumPaletteStart() {
        return this.spectrumPaletteStart;
    }

    public void setDrawingOffsets(int xOffsetLeft, int width) {
        this.chartXOffset = xOffsetLeft;
        this.chartWidth = width;
    }

    public synchronized void setHistorySize(int historyInPixels) {
        BufferedImage[] bufferedImages = new BufferedImage[]{GraphicsToolkit.createAcceleratedImageOpaque(this.screenWidth, historyInPixels), GraphicsToolkit.createAcceleratedImageOpaque(this.screenWidth, historyInPixels)};
        this.copyImage(this.bufferedImages[0], bufferedImages[0]);
        this.copyImage(this.bufferedImages[1], bufferedImages[1]);
        this.bufferedImages = bufferedImages;
    }

    public void setSpectrumPaletteSize(int dB) {
        this.spectrumPaletteSize = dB;
    }

    public void setSpectrumPaletteStart(int dB) {
        this.spectrumPaletteStart = dB;
    }

    public void setStatusMessage(String message, int index) {
        this.statusMessage[index] = message;
    }

    private void copyImage(BufferedImage src, BufferedImage dst) {
        Graphics2D g = dst.createGraphics();
        g.drawImage((Image)src, 0, 0, null);
        g.dispose();
    }

    private double translateChartXToFrequency(int x) {
        if (this.lastSpectrum != null) {
            double startFreq = (double)this.lastSpectrum.getFreqStartMHz() * 1000000.0;
            double stopFreq = (double)this.lastSpectrum.getFreqStopMHz() * 1000000.0;
            double freqRange = stopFreq - startFreq;
            double width = this.bufferedImages[0].getWidth();
            double percentageFreq = (double)x / (double)this.chartWidth;
            double freq = percentageFreq * freqRange + startFreq;
            if (freq > stopFreq) {
                freq = stopFreq;
            }
            if (freq < startFreq) {
                freq = startFreq;
            }
            return freq;
        }
        return -1.0;
    }

    @Override
    protected void paintComponent(Graphics arg0) {
        long drawStart = System.nanoTime();
        Graphics2D g = (Graphics2D)arg0;
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        int w = this.chartWidth;
        int h = this.getHeight();
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.bufferedImages[this.drawIndex], this.chartXOffset, 0, w, h, null);
        if (this.displayMarker) {
            g.setColor(Color.gray);
            g.drawLine(this.displayMarkerX, 0, this.displayMarkerX, h);
            g.drawString(String.format("%.1fMHz", this.displayMarkerFrequency / 1000000.0), this.displayMarkerX + 5, h / 2);
        }
        g.setColor(Color.white);
        if (this.stringBounds == null) {
            this.stringBounds = g.getFontMetrics().getStringBounds("TEST", g);
        }
        int fontHeight = (int)this.stringBounds.getHeight();
        int x = this.chartXOffset + w - 350;
        int y = h - fontHeight * (this.statusMessage.length + 1);
        g.drawString(this.renderingInfo, x, y);
        int i = 0;
        while (i < this.statusMessage.length) {
            if (this.statusMessage[i] != null) {
                g.drawString(this.statusMessage[i], x, y + fontHeight * (i + 1));
            }
            ++i;
        }
        long drawingTime = System.nanoTime() - drawStart;
        this.drawingTimeSum += drawingTime;
        ++this.drawingCounter;
    }

    public int getDrawingCounterAndReset() {
        int val = this.drawingCounter;
        this.drawingCounter = 0;
        return val;
    }

    public long getDrawTimeSumAndReset() {
        long val = this.drawingTimeSum;
        this.drawingTimeSum = 0L;
        return val;
    }
}

