/*
 * Decompiled with CFR 0.152.
 */
package jspectrumanalyzer.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Label;
import java.awt.LayoutManager;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import jspectrumanalyzer.core.FrequencyAllocationTable;
import jspectrumanalyzer.core.FrequencyAllocations;
import jspectrumanalyzer.core.HackRFSettings;
import jspectrumanalyzer.ui.FrequencySelectorPanel;
import jspectrumanalyzer.ui.FrequencySelectorRangeBinder;
import net.miginfocom.swing.MigLayout;
import shared.mvc.MVCController;

public class HackRFSweepSettingsUI
extends JPanel {
    private HackRFSettings hRF;
    private static final long serialVersionUID = 7721079457485020637L;
    private JLabel txtHackrfConnected;
    private FrequencySelectorPanel frequencySelectorStart;
    private FrequencySelectorPanel frequencySelectorEnd;
    private JSpinner spinnerFFTBinHz;
    private JSlider sliderGain;
    private JSpinner spinner_numberOfSamples;
    private JCheckBox chckbxAntennaPower;
    private JSlider slider_waterfallPaletteStart;
    private JSlider slider_waterfallPaletteSize;
    private JCheckBox chckbxShowPeaks;
    private JCheckBox chckbxRemoveSpurs;
    private JButton btnPause;
    private SpinnerListModel spinnerModelFFTBinHz;
    private FrequencySelectorRangeBinder frequencyRangeSelector;
    private JCheckBox chckbxFilterSpectrum;
    private JSpinner spinnerPeakFallSpeed;
    private JComboBox<FrequencyAllocationTable> comboBoxFrequencyAllocationBands;
    private JSlider sliderGainVGA;
    private JSlider sliderGainLNA;
    private JCheckBox chckbxAntennaLNA;
    private JLabel lblPeakFall;
    private JComboBox<BigDecimal> comboBoxLineThickness;
    private JLabel lblPersistentDisplay;
    private JCheckBox checkBoxPersistentDisplay;
    private JCheckBox checkBoxWaterfallEnabled;
    private JLabel lblDecayRate;
    private JComboBox comboBoxDecayRate;
    private JLabel lblDebugDisplay;
    private JCheckBox checkBoxDebugDisplay;

    public HackRFSweepSettingsUI(HackRFSettings hackRFSettings) {
        this.hRF = hackRFSettings;
        this.setForeground(Color.WHITE);
        this.setBackground(Color.BLACK);
        int minFreq = 1;
        int maxFreq = 7250;
        int freqStep = 1;
        JPanel panelMainSettings = new JPanel((LayoutManager)new MigLayout("", "[123.00px,grow,leading]", "[][][::0px][][]"));
        panelMainSettings.setBorder(new EmptyBorder(UIManager.getInsets("TabbedPane.tabAreaInsets")));
        panelMainSettings.setBackground(Color.BLACK);
        JLabel lblNewLabel = new JLabel("Frequency start [MHz]");
        lblNewLabel.setForeground(Color.WHITE);
        panelMainSettings.add((Component)lblNewLabel, "cell 0 0,growx,aligny center");
        this.frequencySelectorStart = new FrequencySelectorPanel(minFreq, maxFreq, freqStep, minFreq);
        panelMainSettings.add((Component)this.frequencySelectorStart, "cell 0 1,grow");
        JLabel lblFrequencyEndmhz = new JLabel("Frequency end [MHz]");
        lblFrequencyEndmhz.setForeground(Color.WHITE);
        panelMainSettings.add((Component)lblFrequencyEndmhz, "cell 0 3,alignx left,aligny center");
        this.frequencySelectorEnd = new FrequencySelectorPanel(minFreq, maxFreq, freqStep, maxFreq);
        panelMainSettings.add((Component)this.frequencySelectorEnd, "cell 0 4,grow");
        this.txtHackrfConnected = new JLabel();
        this.txtHackrfConnected.setText("HackRF disconnected");
        this.txtHackrfConnected.setForeground(Color.WHITE);
        this.txtHackrfConnected.setBackground(Color.BLACK);
        panelMainSettings.add((Component)this.txtHackrfConnected, "cell 0 23,growx");
        this.txtHackrfConnected.setBorder(null);
        this.btnPause = new JButton("Pause");
        panelMainSettings.add((Component)this.btnPause, "cell 0 25,growx");
        this.btnPause.setBackground(Color.black);
        JTabbedPane tabbedPane = new JTabbedPane(1);
        this.setLayout(new BorderLayout());
        this.add((Component)panelMainSettings, "North");
        this.add((Component)tabbedPane, "Center");
        tabbedPane.setForeground(Color.WHITE);
        tabbedPane.setBackground(Color.BLACK);
        JPanel tab1 = new JPanel((LayoutManager)new MigLayout("", "[123.00px,grow,leading]", "[][][0][][][0][][][0][][][0][][][0][][0][][grow,fill]"));
        tab1.setForeground(Color.WHITE);
        tab1.setBackground(Color.BLACK);
        JPanel tab2 = new JPanel((LayoutManager)new MigLayout("", "[123.00px,grow,leading]", "[][0][][][0][][][0][][0][][][0][][0][][][0][0][][][0][][0][grow,fill]"));
        tab2.setForeground(Color.WHITE);
        tab2.setBackground(Color.BLACK);
        tabbedPane.addTab("HackRF Settings", tab1);
        tabbedPane.addTab("Chart options", tab2);
        tabbedPane.setForegroundAt(1, Color.BLACK);
        tabbedPane.setBackgroundAt(1, Color.WHITE);
        tabbedPane.setForegroundAt(0, Color.BLACK);
        tabbedPane.setBackgroundAt(0, Color.WHITE);
        JLabel lblGain = new JLabel("Gain [dB]");
        lblGain.setForeground(Color.WHITE);
        tab1.add((Component)lblGain, "cell 0 0");
        this.sliderGain = new JSlider(0, 0, 100, 2);
        this.sliderGain.setFont(new Font("Monospaced", 1, 16));
        this.sliderGain.setBackground(Color.BLACK);
        this.sliderGain.setForeground(Color.WHITE);
        tab1.add((Component)this.sliderGain, "flowy,cell 0 1,growx");
        JLabel lbl_gainValue = new JLabel(hackRFSettings.getGain() + "dB");
        lbl_gainValue.setForeground(Color.WHITE);
        tab1.add((Component)lbl_gainValue, "cell 0 1,alignx right");
        JLabel lblNewLabel_2 = new JLabel("LNA Gain [dB]");
        lblNewLabel_2.setForeground(Color.WHITE);
        tab1.add((Component)lblNewLabel_2, "cell 0 3");
        this.sliderGainLNA = new JSlider(0, 0, 100, 2);
        this.sliderGainLNA.setForeground(Color.WHITE);
        this.sliderGainLNA.setFont(new Font("Monospaced", 1, 16));
        this.sliderGainLNA.setBackground(Color.BLACK);
        tab1.add((Component)this.sliderGainLNA, "cell 0 4,growx");
        JLabel lblVgfaGaindb = new JLabel("VGA Gain [dB]");
        lblVgfaGaindb.setForeground(Color.WHITE);
        tab1.add((Component)lblVgfaGaindb, "cell 0 6");
        this.sliderGainVGA = new JSlider(0, 0, 100, 2);
        this.sliderGainVGA.setForeground(Color.WHITE);
        this.sliderGainVGA.setFont(new Font("Monospaced", 1, 16));
        this.sliderGainVGA.setBackground(Color.BLACK);
        tab1.add((Component)this.sliderGainVGA, "cell 0 7,growx");
        JLabel lblLNAEnable = new JLabel("Antenna LNA +14dB");
        lblLNAEnable.setForeground(Color.WHITE);
        tab1.add((Component)lblLNAEnable, "flowx,cell 0 8,growx");
        this.chckbxAntennaLNA = new JCheckBox("");
        this.chckbxAntennaLNA.setHorizontalTextPosition(10);
        this.chckbxAntennaLNA.setBackground(Color.BLACK);
        this.chckbxAntennaLNA.setForeground(Color.WHITE);
        tab1.add((Component)this.chckbxAntennaLNA, "cell 0 8,alignx right");
        JLabel lblFftBinhz = new JLabel("FFT Bin [Hz]");
        lblFftBinhz.setForeground(Color.WHITE);
        tab1.add((Component)lblFftBinhz, "cell 0 10");
        this.spinnerFFTBinHz = new JSpinner();
        this.spinnerFFTBinHz.setFont(new Font("Monospaced", 1, 16));
        this.spinnerModelFFTBinHz = new SpinnerListModel(new String[]{"1 000", "2 000", "5 000", "10 000", "20 000", "50 000", "100 000", "200 000", "500 000", "1 000 000", "2 000 000", "5 000 000"});
        this.spinnerFFTBinHz.setModel(this.spinnerModelFFTBinHz);
        tab1.add((Component)this.spinnerFFTBinHz, "cell 0 12,growx");
        ((JSpinner.ListEditor)this.spinnerFFTBinHz.getEditor()).getTextField().setHorizontalAlignment(4);
        hackRFSettings.getGain().addListener(gain -> lbl_gainValue.setText(String.format(" %ddB  [LNA: %ddB  VGA: %ddB]", gain, hackRFSettings.getGainLNA().getValue(), hackRFSettings.getGainVGA().getValue())));
        JLabel lblNumberOfSamples = new JLabel("Number of samples");
        lblNumberOfSamples.setForeground(Color.WHITE);
        tab1.add((Component)lblNumberOfSamples, "cell 0 13");
        this.spinner_numberOfSamples = new JSpinner();
        this.spinner_numberOfSamples.setModel(new SpinnerListModel(new String[]{"8192", "16384", "32768", "65536", "131072", "262144"}));
        this.spinner_numberOfSamples.setFont(new Font("Monospaced", 1, 16));
        ((JSpinner.ListEditor)this.spinner_numberOfSamples.getEditor()).getTextField().setHorizontalAlignment(4);
        ((JSpinner.ListEditor)this.spinner_numberOfSamples.getEditor()).getTextField().setEditable(false);
        tab1.add((Component)this.spinner_numberOfSamples, "cell 0 14,growx");
        JButton btnAbout = new JButton("Visit homepage");
        btnAbout.addActionListener(e -> {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    URI uri = new URI("https://github.com/pavsa/hackrf-spectrum-analyzer");
                    desktop.browse(uri);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JLabel lblAntennaPower = new JLabel("Antenna power output");
        lblAntennaPower.setForeground(Color.WHITE);
        tab1.add((Component)lblAntennaPower, "flowx,cell 0 16,growx");
        this.chckbxAntennaPower = new JCheckBox("");
        this.chckbxAntennaPower.setHorizontalTextPosition(10);
        this.chckbxAntennaPower.setBackground(Color.BLACK);
        this.chckbxAntennaPower.setForeground(Color.WHITE);
        tab1.add((Component)this.chckbxAntennaPower, "cell 0 16,alignx right");
        Label labelVersion = new Label("Version: v1.5");
        tab1.add((Component)labelVersion, "flowx,cell 0 17");
        btnAbout.setBackground(Color.BLACK);
        tab1.add((Component)btnAbout, "cell 0 17,alignx right");
        this.chckbxFilterSpectrum = new JCheckBox("Filter spectrum");
        this.chckbxFilterSpectrum.setBackground(Color.BLACK);
        this.chckbxFilterSpectrum.setForeground(Color.WHITE);
        JLabel lblWaterfallEnabled = new JLabel("Waterfall enabled");
        lblWaterfallEnabled.setForeground(Color.WHITE);
        tab2.add((Component)lblWaterfallEnabled, "flowx,cell 0 0,growx");
        JLabel lblWaterfallPaletteStart = new JLabel("Waterfall palette start [dB]");
        lblWaterfallPaletteStart.setForeground(Color.WHITE);
        tab2.add((Component)lblWaterfallPaletteStart, "cell 0 2");
        this.slider_waterfallPaletteStart = new JSlider();
        this.slider_waterfallPaletteStart.setForeground(Color.WHITE);
        this.slider_waterfallPaletteStart.setBackground(Color.BLACK);
        this.slider_waterfallPaletteStart.setMinimum(-100);
        this.slider_waterfallPaletteStart.setMaximum(0);
        this.slider_waterfallPaletteStart.setValue(-30);
        tab2.add((Component)this.slider_waterfallPaletteStart, "cell 0 3,growx");
        JLabel lblWaterfallPaletteLength = new JLabel("Waterfall palette length [dB]");
        lblWaterfallPaletteLength.setForeground(Color.WHITE);
        tab2.add((Component)lblWaterfallPaletteLength, "cell 0 5");
        this.slider_waterfallPaletteSize = new JSlider(5, 100);
        this.slider_waterfallPaletteSize.setBackground(Color.BLACK);
        this.slider_waterfallPaletteSize.setForeground(Color.WHITE);
        tab2.add((Component)this.slider_waterfallPaletteSize, "cell 0 6,growx");
        JLabel lblSpectrLineThickness = new JLabel("Spectr. Line Thickness");
        lblSpectrLineThickness.setForeground(Color.WHITE);
        tab2.add((Component)lblSpectrLineThickness, "flowx,cell 0 8,growx");
        JLabel lblShowPeaks = new JLabel("Show peaks");
        lblShowPeaks.setForeground(Color.WHITE);
        tab2.add((Component)lblShowPeaks, "flowx,cell 0 10,growx");
        this.chckbxShowPeaks = new JCheckBox("");
        this.chckbxShowPeaks.setForeground(Color.WHITE);
        this.chckbxShowPeaks.setBackground(Color.BLACK);
        tab2.add((Component)this.chckbxShowPeaks, "cell 0 10,alignx right");
        JLabel lblSpurFiltermay = new JLabel("Spur filter (may distort real signals)");
        lblSpurFiltermay.setForeground(Color.WHITE);
        tab2.add((Component)lblSpurFiltermay, "flowx,cell 0 13,growx");
        this.chckbxRemoveSpurs = new JCheckBox("");
        this.chckbxRemoveSpurs.setForeground(Color.WHITE);
        this.chckbxRemoveSpurs.setBackground(Color.BLACK);
        tab2.add((Component)this.chckbxRemoveSpurs, "cell 0 13,alignx right");
        this.lblPeakFall = new JLabel("  Fall speed [s]");
        this.lblPeakFall.setForeground(Color.WHITE);
        tab2.add((Component)this.lblPeakFall, "flowx,cell 0 11,growx");
        this.spinnerPeakFallSpeed = new JSpinner();
        this.spinnerPeakFallSpeed.setModel(new SpinnerNumberModel(10, 0, 500, 1));
        tab2.add((Component)this.spinnerPeakFallSpeed, "cell 0 11,alignx right");
        this.lblPersistentDisplay = new JLabel("Persistent Display");
        this.lblPersistentDisplay.setForeground(Color.WHITE);
        tab2.add((Component)this.lblPersistentDisplay, "flowx,cell 0 15,growx");
        this.lblDecayRate = new JLabel("  Persistence time [s]");
        this.lblDecayRate.setForeground(Color.WHITE);
        tab2.add((Component)this.lblDecayRate, "flowx,cell 0 16,growx");
        JLabel lblDisplayFrequencyAllocation = new JLabel("Frequency Allocation Bands");
        lblDisplayFrequencyAllocation.setForeground(Color.WHITE);
        tab2.add((Component)lblDisplayFrequencyAllocation, "cell 0 19");
        FrequencyAllocations frequencyAllocations = new FrequencyAllocations();
        Vector<FrequencyAllocationTable> freqAllocValues = new Vector<FrequencyAllocationTable>();
        freqAllocValues.add(null);
        freqAllocValues.addAll(frequencyAllocations.getTable().values());
        DefaultComboBoxModel freqAllocModel = new DefaultComboBoxModel(freqAllocValues);
        this.comboBoxFrequencyAllocationBands = new JComboBox(freqAllocModel);
        tab2.add(this.comboBoxFrequencyAllocationBands, "cell 0 20,growx");
        this.comboBoxLineThickness = new JComboBox<BigDecimal>(new BigDecimal[]{new BigDecimal("1"), new BigDecimal("1.5"), new BigDecimal("2"), new BigDecimal("3")});
        tab2.add(this.comboBoxLineThickness, "cell 0 8,alignx right");
        this.checkBoxPersistentDisplay = new JCheckBox("");
        this.checkBoxPersistentDisplay.setForeground(Color.WHITE);
        this.checkBoxPersistentDisplay.setBackground(Color.BLACK);
        tab2.add((Component)this.checkBoxPersistentDisplay, "cell 0 15,alignx right");
        this.checkBoxWaterfallEnabled = new JCheckBox("");
        this.checkBoxWaterfallEnabled.setForeground(Color.WHITE);
        this.checkBoxWaterfallEnabled.setBackground(Color.BLACK);
        tab2.add((Component)this.checkBoxWaterfallEnabled, "cell 0 0,alignx right");
        this.comboBoxDecayRate = new JComboBox(new Vector(IntStream.rangeClosed(this.hRF.getPersistentDisplayDecayRate().getMin(), this.hRF.getPersistentDisplayDecayRate().getMax()).boxed().collect(Collectors.toList())));
        tab2.add((Component)this.comboBoxDecayRate, "cell 0 16,alignx right");
        this.lblDebugDisplay = new JLabel("Debug display");
        this.lblDebugDisplay.setForeground(Color.WHITE);
        tab2.add((Component)this.lblDebugDisplay, "flowx,cell 0 22,growx");
        this.checkBoxDebugDisplay = new JCheckBox("");
        this.checkBoxDebugDisplay.setForeground(Color.WHITE);
        this.checkBoxDebugDisplay.setBackground(Color.BLACK);
        tab2.add((Component)this.checkBoxDebugDisplay, "cell 0 22,alignx right");
        this.bindViewToModel();
    }

    private void bindViewToModel() {
        this.frequencyRangeSelector = new FrequencySelectorRangeBinder(this.frequencySelectorStart, this.frequencySelectorEnd);
        new MVCController(this.spinnerFFTBinHz, this.hRF.getFFTBinHz(), viewValue -> Integer.parseInt(viewValue.toString().replaceAll("\\s", "")), modelValue -> {
            Optional<Object> val = this.spinnerModelFFTBinHz.getList().stream().filter(value -> modelValue <= Integer.parseInt(value.toString().replaceAll("\\s", ""))).findFirst();
            if (val.isPresent()) {
                return val.get();
            }
            return this.spinnerModelFFTBinHz.getList().get(0);
        });
        new MVCController(this.sliderGain, this.hRF.getGain());
        new MVCController(this.spinner_numberOfSamples, this.hRF.getSamples(), val -> Integer.parseInt(val.toString()), val -> val.toString());
        new MVCController(this.chckbxAntennaPower, this.hRF.getAntennaPowerEnable());
        new MVCController(this.chckbxAntennaLNA, this.hRF.getAntennaLNA());
        new MVCController(this.slider_waterfallPaletteStart, this.hRF.getSpectrumPaletteStart());
        new MVCController(this.slider_waterfallPaletteSize, this.hRF.getSpectrumPaletteSize());
        new MVCController(valueChangedCall -> this.frequencyRangeSelector.addPropertyChangeListener(evt -> valueChangedCall.accept(this.frequencyRangeSelector.getFrequencyRange())), newComponentValue -> {
            if (this.frequencyRangeSelector.selFreqStart.getValue() != newComponentValue.getStartMHz()) {
                this.frequencyRangeSelector.selFreqStart.setValue(newComponentValue.getStartMHz());
            }
            if (this.frequencyRangeSelector.selFreqEnd.getValue() != newComponentValue.getEndMHz()) {
                this.frequencyRangeSelector.selFreqEnd.setValue(newComponentValue.getEndMHz());
            }
        }, this.hRF.getFrequency());
        new MVCController(this.chckbxShowPeaks, this.hRF.isChartsPeaksVisible());
        new MVCController(this.chckbxFilterSpectrum, this.hRF.isFilterSpectrum());
        new MVCController(this.chckbxRemoveSpurs, this.hRF.isSpurRemoval());
        new MVCController(valueChangedCall -> this.btnPause.addActionListener(event -> valueChangedCall.accept((Boolean)this.hRF.isCapturingPaused().getValue() == false)), isCapt -> this.btnPause.setText(isCapt == false ? "Pause" : "Resume"), this.hRF.isCapturingPaused());
        new MVCController(this.spinnerPeakFallSpeed, this.hRF.getPeakFallRate(), in -> (Integer)in, in -> in);
        new MVCController(this.comboBoxFrequencyAllocationBands, this.hRF.getFrequencyAllocationTable());
        this.sliderGainLNA.setModel(new DefaultBoundedRangeModel((Integer)this.hRF.getGainLNA().getValue(), 0, this.hRF.getGainLNA().getMin(), this.hRF.getGainLNA().getMax()));
        this.sliderGainVGA.setModel(new DefaultBoundedRangeModel((Integer)this.hRF.getGainVGA().getValue(), 0, this.hRF.getGainVGA().getMin(), this.hRF.getGainVGA().getMax()));
        this.sliderGainLNA.setSnapToTicks(true);
        this.sliderGainLNA.setMinorTickSpacing(this.hRF.getGainLNA().getStep());
        this.sliderGainVGA.setSnapToTicks(true);
        this.sliderGainVGA.setMinorTickSpacing(this.hRF.getGainVGA().getStep());
        new MVCController(this.sliderGainLNA, this.hRF.getGainLNA());
        new MVCController(this.sliderGainVGA, this.hRF.getGainVGA());
        new MVCController(this.comboBoxLineThickness, this.hRF.getSpectrumLineThickness());
        new MVCController(this.checkBoxPersistentDisplay, this.hRF.isPersistentDisplayVisible());
        new MVCController(this.checkBoxWaterfallEnabled, this.hRF.isWaterfallVisible());
        new MVCController(this.checkBoxDebugDisplay, this.hRF.isDebugDisplay());
        this.hRF.isChartsPeaksVisible().addListener(enabled -> SwingUtilities.invokeLater(() -> {
            this.spinnerPeakFallSpeed.setEnabled((boolean)enabled);
            this.spinnerPeakFallSpeed.setVisible((boolean)enabled);
            this.lblPeakFall.setVisible((boolean)enabled);
        }));
        this.hRF.isChartsPeaksVisible().callObservers();
        new MVCController(this.comboBoxDecayRate, this.hRF.getPersistentDisplayDecayRate());
        this.hRF.isPersistentDisplayVisible().addListener(visible -> SwingUtilities.invokeLater(() -> {
            this.comboBoxDecayRate.setVisible((boolean)visible);
            this.lblDecayRate.setVisible((boolean)visible);
        }));
        this.hRF.isPersistentDisplayVisible().callObservers();
        this.hRF.registerListener(new HackRFSettings.HackRFEventAdapter(){

            @Override
            public void captureStateChanged(boolean isCapturing) {
            }

            @Override
            public void hardwareStatusChanged(boolean hardwareSendingData) {
                HackRFSweepSettingsUI.this.txtHackrfConnected.setText("HackRF " + (hardwareSendingData ? "connected" : "disconnected"));
            }
        });
    }
}

