/*
 * Decompiled with CFR 0.152.
 */
package jspectrumanalyzer.ui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import jspectrumanalyzer.core.FrequencyRange;
import jspectrumanalyzer.ui.FrequencySelectorPanel;

public class FrequencySelectorRangeBinder {
    public FrequencySelectorPanel selFreqStart;
    public FrequencySelectorPanel selFreqEnd;

    public FrequencySelectorRangeBinder(FrequencySelectorPanel selFreqStart, FrequencySelectorPanel selFreqEnd) {
        this.selFreqEnd = selFreqEnd;
        this.selFreqStart = selFreqStart;
        VetoableChangeListener freqStartVetoable = evt -> {
            Integer newVal = (Integer)evt.getNewValue();
            if (newVal >= selFreqEnd.getValue() && !selFreqEnd.setValue(selFreqEnd.getValue() + (newVal - (Integer)evt.getOldValue()))) {
                throw new PropertyVetoException(">", evt);
            }
        };
        VetoableChangeListener freqEndVetoable = evt -> {
            Integer newVal = (Integer)evt.getNewValue();
            if (newVal <= selFreqStart.getValue() && !selFreqStart.setValue(selFreqStart.getValue() - ((Integer)evt.getOldValue() - newVal))) {
                throw new PropertyVetoException(">", evt);
            }
        };
        selFreqEnd.addVetoableChangeListener(freqEndVetoable);
        selFreqStart.addVetoableChangeListener(freqStartVetoable);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.selFreqStart.addPropertyChangeListener("value", propertyChangeListener);
        this.selFreqEnd.addPropertyChangeListener("value", propertyChangeListener);
    }

    public FrequencyRange getFrequencyRange() {
        return new FrequencyRange(this.selFreqStart.getValue(), this.selFreqEnd.getValue());
    }
}

