/*
 * Decompiled with CFR 0.152.
 */
package jspectrumanalyzer.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class FrequencySelectorPanel
extends JPanel {
    private static final long serialVersionUID = -4830755053319335365L;
    private int minValue;
    private int maxValue;
    private int step;
    private int intialValue;
    private JTextField textField_val1;
    private JTextField textField_val2;
    private JTextField textField_val3;
    private JTextField textField_val4;
    private int value = 0;

    public FrequencySelectorPanel(int minValue, int maxValue, int step, int intialValue) {
        this.setBackground(Color.BLACK);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.step = step;
        this.setLayout(new GridLayout(0, 4, 0, 0));
        JButton button_plus4 = new JButton("+");
        button_plus4.setBackground(Color.BLACK);
        this.add(button_plus4);
        JButton button_plus3 = new JButton("+");
        button_plus3.setBackground(Color.BLACK);
        this.add(button_plus3);
        JButton button_plus2 = new JButton("+");
        button_plus2.setBackground(Color.BLACK);
        this.add(button_plus2);
        JButton button_plus1 = new JButton("+");
        button_plus1.setBackground(Color.BLACK);
        this.add(button_plus1);
        Font fontField = new Font("Monospaced", 1, 16);
        this.textField_val4 = new JTextField();
        this.textField_val4.setFont(fontField);
        this.textField_val4.setHorizontalAlignment(0);
        this.textField_val4.setEditable(false);
        this.add(this.textField_val4);
        this.textField_val4.setColumns(1);
        this.textField_val4.setBorder(null);
        this.textField_val3 = new JTextField();
        this.textField_val3.setFont(fontField);
        this.textField_val3.setHorizontalAlignment(0);
        this.textField_val3.setEditable(false);
        this.add(this.textField_val3);
        this.textField_val3.setColumns(1);
        this.textField_val3.setBorder(null);
        this.textField_val2 = new JTextField();
        this.textField_val2.setFont(fontField);
        this.textField_val2.setHorizontalAlignment(0);
        this.textField_val2.setEditable(false);
        this.add(this.textField_val2);
        this.textField_val2.setColumns(1);
        this.textField_val2.setBorder(null);
        this.textField_val1 = new JTextField();
        this.textField_val1.setText("0");
        this.textField_val1.setFont(fontField);
        this.textField_val1.setHorizontalAlignment(0);
        this.textField_val1.setEditable(false);
        this.add(this.textField_val1);
        this.textField_val1.setColumns(1);
        this.textField_val1.setBorder(null);
        JButton button_minus4 = new JButton("-");
        button_minus4.setBackground(Color.BLACK);
        this.add(button_minus4);
        JButton button_minus3 = new JButton("-");
        button_minus3.setBackground(Color.BLACK);
        this.add(button_minus3);
        JButton button_minus2 = new JButton("-");
        button_minus2.setBackground(Color.BLACK);
        this.add(button_minus2);
        JButton button_minus1 = new JButton("-");
        button_minus1.setBackground(Color.BLACK);
        this.add(button_minus1);
        button_plus1.addActionListener(this.addListener(true, 1));
        button_plus2.addActionListener(this.addListener(true, 2));
        button_plus3.addActionListener(this.addListener(true, 3));
        button_plus4.addActionListener(this.addListener(true, 4));
        button_minus1.addActionListener(this.addListener(false, 1));
        button_minus2.addActionListener(this.addListener(false, 2));
        button_minus3.addActionListener(this.addListener(false, 3));
        button_minus4.addActionListener(this.addListener(false, 4));
        Dimension d = new Dimension(175, 65);
        this.setPreferredSize(d);
        this.setMaximumSize(d);
        this.setMinimumSize(d);
        this.setValue(intialValue);
    }

    public int getValue() {
        return this.value;
    }

    public boolean setValue(int newValue) {
        if (newValue < this.minValue || newValue > this.maxValue) {
            return false;
        }
        int oldValue = this.value;
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    try {
                        this.fireValueChange(oldValue, newValue);
                    }
                    catch (PropertyVetoException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                return false;
            }
            catch (InterruptedException e) {
                return false;
            }
            return true;
        }
        try {
            this.fireValueChange(oldValue, newValue);
            return true;
        }
        catch (PropertyVetoException e) {
            return false;
        }
    }

    private void add(int digit) {
        int newValue = this.value + this.getMultiplier(digit);
        if (newValue < this.minValue) {
            newValue = this.minValue;
        }
        if (newValue > this.maxValue) {
            newValue = this.maxValue;
        }
        this.setValue(newValue);
    }

    private ActionListener addListener(boolean add, int digit) {
        ActionListener listener = e -> {
            if (add) {
                this.add(digit);
            } else {
                this.subtract(digit);
            }
        };
        return listener;
    }

    private void fireValueChange(int oldValue, int newValue) throws PropertyVetoException {
        this.fireVetoableChange("value", oldValue, newValue);
        this.value = newValue;
        int digit1 = newValue % 10;
        int digit2 = newValue / 10 % 10;
        int digit3 = newValue / 100 % 10;
        int digit4 = newValue / 1000 % 10;
        this.textField_val1.setText(String.valueOf(digit1));
        this.textField_val2.setText(digit4 == 0 && digit3 == 0 && digit2 == 0 ? " " : String.valueOf(digit2));
        this.textField_val3.setText(digit4 == 0 && digit3 == 0 ? " " : String.valueOf(digit3));
        this.textField_val4.setText(digit4 == 0 ? "" : String.valueOf(digit4));
        this.firePropertyChange("value", oldValue, newValue);
    }

    private int getMultiplier(int digit) {
        int multiplier = 1;
        int i = 0;
        while (i < digit - 1) {
            multiplier *= 10;
            ++i;
        }
        return multiplier;
    }

    private void subtract(int digit) {
        int newValue = this.value - this.getMultiplier(digit);
        if (newValue < this.minValue) {
            newValue = this.minValue;
        }
        if (newValue > this.maxValue) {
            newValue = this.maxValue;
        }
        this.setValue(newValue);
    }
}

