/*
 * Decompiled with CFR 0.152.
 */
package jspectrumanalyzer.nativebridge;

import com.sun.jna.Callback;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.FloatByReference;
import hackrfsweep.HackrfSweepLibrary;
import jspectrumanalyzer.nativebridge.HackRFSweepDataCallback;

public class HackRFSweepNativeBridge {
    public static final String JNA_LIBRARY_NAME = "hackrf-sweep";
    public static final NativeLibrary JNA_NATIVE_LIB;

    static {
        String pathPrefix = "./" + Platform.RESOURCE_PREFIX + "/";
        System.setProperty("jna.boot.library.path", pathPrefix);
        System.setProperty("jna.nosys", "true");
        NativeLibrary.addSearchPath((String)JNA_LIBRARY_NAME, (String)pathPrefix);
        JNA_NATIVE_LIB = NativeLibrary.getInstance((String)JNA_LIBRARY_NAME);
        Native.register(HackrfSweepLibrary.class, (NativeLibrary)JNA_NATIVE_LIB);
    }

    public static synchronized void start(final HackRFSweepDataCallback dataCallback, int freq_min_MHz, int freq_max_MHz, int fft_bin_width, int num_samples, int lna_gain, int vga_gain, boolean antennaPowerEnable, boolean internalLNA) {
        HackrfSweepLibrary.hackrf_sweep_lib_start__fft_power_callback_callback callback = new HackrfSweepLibrary.hackrf_sweep_lib_start__fft_power_callback_callback(){

            @Override
            public void apply(byte sweep_started, int bins, DoubleByReference freqStart, float fftBinWidth, FloatByReference powerdBm) {
                double[] freqStartArr = bins == 0 ? null : freqStart.getPointer().getDoubleArray(0L, bins);
                float[] powerArr = bins == 0 ? null : powerdBm.getPointer().getFloatArray(0L, bins);
                dataCallback.newSpectrumData(sweep_started != 0, freqStartArr, fftBinWidth, powerArr);
            }
        };
        Native.setCallbackThreadInitializer((Callback)callback, (CallbackThreadInitializer)new CallbackThreadInitializer(true));
        HackrfSweepLibrary.hackrf_sweep_lib_start(callback, freq_min_MHz, freq_max_MHz, fft_bin_width, num_samples, lna_gain, vga_gain, antennaPowerEnable ? 1 : 0, internalLNA ? 1 : 0);
    }

    public static void stop() {
        HackrfSweepLibrary.hackrf_sweep_lib_stop();
    }
}

