/*
 * Decompiled with CFR 0.152.
 */
package jspectrumanalyzer.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import jspectrumanalyzer.core.DatasetSpectrum;
import jspectrumanalyzer.core.EMA;

public class SpurFilter {
    private final DatasetSpectrum avgSpectrum;
    private boolean calibrated = false;
    private int debug = 0;
    private final DatasetSpectrum filter;
    private ArrayList<DatasetSpectrum> filterInputs = new ArrayList();
    private final DatasetSpectrum input;
    private final int maxPeakBins;
    private final float maxPeakJitterdB;
    private final DatasetSpectrum noiseFloor;
    private final float peakThresholdAboveNoise;
    private final int validIterations;

    public SpurFilter(float maxPeakJitterdB, float peakThresholdAboveNoise, int maxPeakBins, int validIterations, DatasetSpectrum input) {
        this.maxPeakJitterdB = maxPeakJitterdB;
        this.peakThresholdAboveNoise = peakThresholdAboveNoise;
        this.maxPeakBins = maxPeakBins;
        this.validIterations = validIterations;
        this.input = input;
        this.filter = new DatasetSpectrum(input.getFFTBinSizeHz(), input.getFreqStartMHz(), input.getFreqStopMHz(), 0.0f);
        this.avgSpectrum = input.cloneMe();
        this.noiseFloor = this.avgSpectrum.cloneMe();
    }

    public void filterDataset() {
        if (this.input.getFFTBinSizeHz() != this.filter.getFFTBinSizeHz() || this.input.spectrumLength() != this.filter.spectrumLength()) {
            throw new IllegalArgumentException("Input dataset not the same size as output dataset");
        }
        if (!this.calibrated) {
            this.calibrate();
            return;
        }
        this.filterDatasetExec();
    }

    public boolean isFilterCalibrated() {
        return this.calibrated;
    }

    public void recalibrate() {
        this.calibrated = false;
        this.filterInputs.clear();
    }

    private void calibrate() {
        if (this.calibrated) {
            return;
        }
        this.filterInputs.add(this.input.cloneMe());
        if (this.filterInputs.size() >= this.validIterations) {
            this.avgSpectrum.setSpectrumInitPower(0.0f);
            this.avgSpectrum.resetSpectrum();
            float[] noiseFloorArr = this.noiseFloor.getSpectrumArray();
            float[] avgSpectrArray = this.avgSpectrum.getSpectrumArray();
            for (DatasetSpectrum datasetSpectrum : this.filterInputs) {
                float[] spectr = datasetSpectrum.getSpectrumArray();
                int i = 0;
                while (i < spectr.length) {
                    int n = i;
                    avgSpectrArray[n] = avgSpectrArray[n] + spectr[i];
                    ++i;
                }
            }
            int i = 0;
            while (i < avgSpectrArray.length) {
                int n = i++;
                avgSpectrArray[n] = avgSpectrArray[n] / (float)this.validIterations;
            }
            LinkedList<Integer> spurIndexes = new LinkedList<Integer>();
            int end = avgSpectrArray.length - this.maxPeakBins;
            double emaNoiseFloor = avgSpectrArray[0];
            double emaNoiseFloorOrder = Math.max(5, noiseFloorArr.length / 50);
            Arrays.fill(noiseFloorArr, 0, this.maxPeakBins, (float)emaNoiseFloor);
            int i2 = this.maxPeakBins;
            while (i2 < end) {
                float currAvgVal = avgSpectrArray[i2];
                boolean triggered1 = false;
                int j = i2 - this.maxPeakBins;
                while (j < i2 && !triggered1) {
                    if ((double)currAvgVal - emaNoiseFloor >= (double)this.peakThresholdAboveNoise) {
                        triggered1 = true;
                    }
                    ++j;
                }
                boolean triggered2 = false;
                int j2 = i2 + 1;
                while (j2 <= i2 + this.maxPeakBins && !triggered2) {
                    if ((double)currAvgVal - emaNoiseFloor >= (double)this.peakThresholdAboveNoise) {
                        triggered2 = true;
                    }
                    ++j2;
                }
                if (triggered1 && triggered2) {
                    spurIndexes.add(i2);
                } else {
                    emaNoiseFloor = EMA.calculate(currAvgVal, emaNoiseFloor, emaNoiseFloorOrder);
                }
                noiseFloorArr[i2] = (float)emaNoiseFloor;
                ++i2;
            }
            Arrays.fill(noiseFloorArr, end, noiseFloorArr.length, (float)emaNoiseFloor);
            Iterator iterator = spurIndexes.iterator();
            while (iterator.hasNext()) {
                Integer spurIndex = (Integer)iterator.next();
                boolean valid = true;
                for (DatasetSpectrum datasetSpectrum : this.filterInputs) {
                    float[] spectr = datasetSpectrum.getSpectrumArray();
                    float diff = Math.abs(spectr[spurIndex] - avgSpectrArray[spurIndex]);
                    if (!(diff > this.maxPeakJitterdB)) continue;
                    valid = false;
                    break;
                }
                if (valid) continue;
                iterator.remove();
            }
            Arrays.fill(this.filter.getSpectrumArray(), 0.0f);
            for (Integer s : spurIndexes) {
                float spurAboveNoise;
                this.filter.getSpectrumArray()[s.intValue()] = spurAboveNoise = avgSpectrArray[s] - noiseFloorArr[s];
            }
            this.calibrated = true;
            return;
        }
        this.calibrated = false;
    }

    private void filterDatasetExec() {
        block5: {
            float[] input;
            block7: {
                block6: {
                    block4: {
                        input = this.input.getSpectrumArray();
                        this.debug = 0;
                        if (this.debug != 0) break block4;
                        int i = 0;
                        while (i < input.length) {
                            int n = i;
                            input[n] = input[n] - this.filter.getSpectrumArray()[i];
                            ++i;
                        }
                        break block5;
                    }
                    if (this.debug != 1) break block6;
                    int i = 0;
                    while (i < input.length) {
                        input[i] = this.avgSpectrum.getSpectrumArray()[i];
                        ++i;
                    }
                    break block5;
                }
                if (this.debug != 2) break block7;
                int i = 0;
                while (i < input.length) {
                    input[i] = this.noiseFloor.getSpectrumArray()[i];
                    ++i;
                }
                break block5;
            }
            if (this.debug != 3) break block5;
            int i = 0;
            while (i < input.length) {
                input[i] = this.noiseFloor.getSpectrumArray()[i] + this.filter.getSpectrumArray()[i];
                ++i;
            }
        }
    }
}

