/*
 * Decompiled with CFR 0.152.
 */
package jspectrumanalyzer.core;

import jspectrumanalyzer.core.FFTBins;

public class PowerCalibration {
    public final double offset_dB;
    public final double gain;

    public PowerCalibration(double expectedPower_dBm, double measuredPower_dBm, double measuredAtGain) {
        this.offset_dB = expectedPower_dBm - measuredPower_dBm;
        this.gain = measuredAtGain;
    }

    public double getOffset_dB(double gain) {
        return this.offset_dB + (this.gain - gain);
    }

    public static void correctPower(PowerCalibration cal, double gain, FFTBins bins) {
        double offset = cal.getOffset_dB(gain);
        int i = 0;
        while (i < bins.sigPowdBm.length) {
            int n = i++;
            bins.sigPowdBm[n] = (float)((double)bins.sigPowdBm[n] + offset);
        }
    }
}

