/*
 * Decompiled with CFR 0.152.
 */
package jspectrumanalyzer.core;

import java.awt.Color;
import java.awt.image.BufferedImage;
import jspectrumanalyzer.core.DatasetSpectrum;
import jspectrumanalyzer.ui.GraphicsToolkit;
import jspectrumanalyzer.ui.HotIronBluePalette;
import shared.mvc.ModelValue;

public class PersistentDisplay {
    private boolean calibrated = false;
    private boolean calibrating = false;
    private long calibrationStarted = 0L;
    private final long calibrationTime = 1000L;
    private ModelValue<BufferedImage> displayImage = new ModelValue<Object>("", null);
    private FloatImage imagePowerAccumulated;
    private int incomingDataCounter = 0;
    private HotIronBluePalette palette = new HotIronBluePalette();
    private int persistenceTimeSecs = 5;
    private float updatesPerSecond = 1.0f;

    public static float map(float in, float in_min, float in_max, float out_min, float out_max) {
        return (in - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
    }

    public static int map(int x, int in_min, int in_max, int out_min, int out_max) {
        return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
    }

    public PersistentDisplay() {
        this.setImageSize(320, 240);
    }

    public void drawSpectrum2(DatasetSpectrum datasetSpectrum, float yMin, float yMax, boolean renderImage) {
        this.drawSpectrumFloat(datasetSpectrum, yMin, yMax, renderImage);
    }

    public void drawSpectrumFloat(DatasetSpectrum datasetSpectrum, float yMin, float yMax, boolean renderImage) {
        if (!this.calibrated) {
            if (!this.calibrating) {
                this.calibrating = true;
                this.calibrationStarted = System.currentTimeMillis();
                this.incomingDataCounter = 0;
            } else {
                ++this.incomingDataCounter;
                long t = System.currentTimeMillis() - this.calibrationStarted;
                if (t >= 1000L) {
                    BufferedImage image;
                    this.updatesPerSecond = (float)this.incomingDataCounter / ((float)t / 1000.0f);
                    int bins = (int)((float)((long)(datasetSpectrum.getFreqStopMHz() - datasetSpectrum.getFreqStartMHz()) * 1000000L) / datasetSpectrum.getFFTBinSizeHz());
                    if (bins < (image = this.displayImage.getValue()).getWidth()) {
                        this.setImageSize(bins, image.getHeight());
                    }
                    this.calibrated = true;
                    this.calibrating = false;
                    if (this.updatesPerSecond < 1.0f) {
                        this.updatesPerSecond = 1.0f;
                    }
                }
            }
            return;
        }
        BufferedImage image = this.displayImage.getValue();
        FloatImage imagePowerAccumulated = this.imagePowerAccumulated;
        if (image == null) {
            return;
        }
        float[] rawImagePowerArr = imagePowerAccumulated.data;
        float order = (float)this.persistenceTimeSecs * this.updatesPerSecond;
        float k = 2.0f / (order + 1.0f);
        float kM1 = 1.0f - k;
        imagePowerAccumulated.multiplyAllValues(kM1);
        float[] spectrum = datasetSpectrum.getSpectrumArray();
        int width = image.getWidth();
        int height = image.getHeight();
        float hDivYRange = (float)(-height) / (yMax - yMin);
        float maxAccumulatedValue = this.updatesPerSecond * (float)this.persistenceTimeSecs;
        int i = 0;
        while (i < spectrum.length) {
            float power = spectrum[i];
            float powerLin = 1.0f;
            int x = i * width / spectrum.length;
            int y = (int)((power - yMin) * hDivYRange + (float)height);
            if (x >= 0 && y >= 0 && x < width && y < height) {
                int index = imagePowerAccumulated.getIndex(x, y);
                if (imagePowerAccumulated.data[index] < maxAccumulatedValue) {
                    float[] fArray = imagePowerAccumulated.data;
                    int n = index;
                    fArray[n] = fArray[n] + powerLin;
                }
            }
            ++i;
        }
        if (renderImage) {
            float maxValue = Float.MIN_NORMAL;
            int i2 = 0;
            while (i2 < rawImagePowerArr.length) {
                float value = rawImagePowerArr[i2];
                if (value > maxValue) {
                    maxValue = value;
                }
                ++i2;
            }
            float setToZeroThreshold = 0.01f;
            float minOutToLog = 1.0f;
            float maxOutToLog = 100.0f;
            float logMin = (float)Math.log10(minOutToLog);
            float logMax = (float)Math.log10(maxOutToLog);
            int x = 0;
            while (x < width) {
                int y = 0;
                while (y < height) {
                    float val = imagePowerAccumulated.get(x, y);
                    if (val < setToZeroThreshold) {
                        imagePowerAccumulated.set(x, y, 0.0f);
                        val = 0.0f;
                    }
                    if (val == 0.0f) {
                        image.setRGB(x, y, Color.black.getRGB());
                    } else {
                        float outPower = val;
                        outPower = (float)Math.log10(PersistentDisplay.map(outPower, 0.0f, maxValue, minOutToLog, maxOutToLog));
                        float normalized = PersistentDisplay.map(outPower, logMin, logMax, 0.15f, 0.95f);
                        Color color = this.palette.getColorNormalized(normalized);
                        image.setRGB(x, y, color.getRGB());
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    public ModelValue<BufferedImage> getDisplayImage() {
        return this.displayImage;
    }

    public int getPersistenceTime() {
        return this.persistenceTimeSecs;
    }

    public void reset() {
        BufferedImage image = this.displayImage.getValue();
        if (image != null) {
            this.setImageSize(image.getWidth(), image.getHeight());
        }
    }

    public void setImageSize(int width, int height) {
        if (width < 1 || height < 1) {
            return;
        }
        this.calibrated = false;
        this.calibrating = false;
        System.out.println("Persistent image set to " + width + "x" + height);
        this.displayImage.setValue(GraphicsToolkit.createAcceleratedImageOpaque(width, height));
        this.imagePowerAccumulated = new FloatImage(width, height);
    }

    public void setPersistenceTime(int persistenceTimeSecs) {
        this.persistenceTimeSecs = persistenceTimeSecs;
    }

    private static class FloatImage {
        private final float[] data;
        private final int width;
        private final int height;

        public FloatImage(int width, int height) {
            this.data = new float[width * height];
            this.width = width;
            this.height = height;
        }

        public float add(int x, int y, float power) {
            int n = y * this.width + x;
            float f = this.data[n] + power;
            this.data[n] = f;
            return f;
        }

        public float get(int x, int y) {
            return this.data[y * this.width + x];
        }

        public int getIndex(int x, int y) {
            return y * this.width + x;
        }

        public void multiplyAllValues(float value) {
            int i = 0;
            while (i < this.data.length) {
                int n = i++;
                this.data[n] = this.data[n] * value;
            }
        }

        public void set(int x, int y, float value) {
            this.data[y * this.width + x] = value;
        }

        public void subtractAllValues(float value) {
            int i = 0;
            while (i < this.data.length) {
                int n = i++;
                this.data[n] = this.data[n] - value;
            }
        }
    }
}

