/*
 * Decompiled with CFR 0.152.
 */
package jspectrumanalyzer.core;

public class FrequencyBand
implements Comparable<FrequencyBand> {
    private final long hzStartIncl;
    private final long hzEndExcl;
    private final String name;
    private final String applications;

    public FrequencyBand(long hzStartIncl, long hzEndExcl, String name, String applications) {
        this.hzStartIncl = hzStartIncl;
        this.hzEndExcl = hzEndExcl;
        this.name = name;
        this.applications = applications;
    }

    public long getHzStartIncl() {
        return this.hzStartIncl;
    }

    public double getMHzStartIncl() {
        return (double)this.hzStartIncl / 1000000.0;
    }

    public long getHzEndExcl() {
        return this.hzEndExcl;
    }

    public double getMHzEndExcl() {
        return (double)this.hzEndExcl / 1000000.0;
    }

    public String getName() {
        return this.name;
    }

    public String getApplications() {
        return this.applications;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(FrequencyBand o) {
        return Long.compare(this.hzStartIncl, o.hzStartIncl);
    }
}

