/*
 * Decompiled with CFR 0.152.
 */
package jspectrumanalyzer.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jspectrumanalyzer.core.FrequencyAllocationTable;
import jspectrumanalyzer.core.FrequencyBand;

public class FrequencyAllocations {
    private HashMap<String, FrequencyAllocationTable> table = new HashMap();

    public FrequencyAllocations() {
        this.loadEurope();
    }

    public HashMap<String, FrequencyAllocationTable> getTable() {
        return new HashMap<String, FrequencyAllocationTable>(this.table);
    }

    private void loadEurope() {
        this.loadTableFromCSV("Europe", this.getClass().getResourceAsStream("/resources/freq-europe.csv"));
        this.loadTableFromCSV("USA", this.getClass().getResourceAsStream("/resources/freq-usa.csv"));
    }

    private void loadTableFromCSV(String locationName, InputStream is) {
        BufferedReader reader = null;
        ArrayList<FrequencyBand> bands = new ArrayList<FrequencyBand>();
        try {
            try {
                Pattern patternCSV = Pattern.compile("\"[^\"]+\";\"([0-9.]+)\\s+-\\s+([0-9.]+)\\s+([kM])Hz\";\"([^\"]+)\";\"([^\"]+)\"");
                reader = new BufferedReader(new InputStreamReader(is));
                String line = null;
                int lineNo = 0;
                while ((line = reader.readLine()) != null) {
                    Matcher m;
                    if (++lineNo == 1 || !(m = patternCSV.matcher(line)).find()) continue;
                    double multiplier = m.group(3).equals("k") ? 1000 : 1000000;
                    long startFreq = Math.round(Double.parseDouble(m.group(1)) * multiplier);
                    long stopFreq = Math.round(Double.parseDouble(m.group(2)) * multiplier);
                    String name = m.group(4);
                    String applications = m.group(5);
                    FrequencyBand band = new FrequencyBand(startFreq, stopFreq, name, applications);
                    bands.add(band);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        FrequencyAllocationTable allocationTable = new FrequencyAllocationTable(locationName, bands);
        this.table.put(locationName, allocationTable);
    }
}

