/*
 * Decompiled with CFR 0.152.
 */
package jspectrumanalyzer.core;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import jspectrumanalyzer.core.FrequencyBand;
import jspectrumanalyzer.ui.GraphicsToolkit;

public class FrequencyAllocationTable {
    private final TreeSet<FrequencyBand> frequencyBands = new TreeSet();
    private final String area;

    public FrequencyAllocationTable(String area, ArrayList<FrequencyBand> bands) {
        this.area = area;
        this.frequencyBands.addAll(bands);
    }

    public FrequencyBand lookupBand(long hz) {
        FrequencyBand band = this.frequencyBands.floor(new FrequencyBand(hz, hz, "", ""));
        return band;
    }

    public String toString() {
        return this.area;
    }

    public ArrayList<FrequencyBand> getFrequencyBands(long startHz, long endHz) {
        FrequencyBand startBand = this.lookupBand(startHz);
        ArrayList<FrequencyBand> bands = new ArrayList<FrequencyBand>();
        SortedSet<FrequencyBand> entries = this.frequencyBands.tailSet(startBand);
        for (FrequencyBand frequencyBand : entries) {
            if (frequencyBand.getHzStartIncl() > endHz) break;
            bands.add(frequencyBand);
        }
        return bands;
    }

    private static float map(float x, float in_min, float in_max, float out_min, float out_max) {
        return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
    }

    public BufferedImage drawAllocationTable(int width, int height, float alpha, long freqStartHz, long freqEndHz, Color textColor, Color bgColor) {
        float rectHeight;
        int scale = 1;
        int drawWidth = width * scale;
        int drawHeight = height * scale;
        BufferedImage i = GraphicsToolkit.createAcceleratedImageTransparent(drawWidth, drawHeight);
        Graphics2D g = i.createGraphics();
        AlphaComposite alcom = AlphaComposite.getInstance(3, alpha);
        g.setComposite(alcom);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(1.0f));
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(Math.toRadians(0.0), 0.0, 0.0);
        Font font = new Font("Dialog", 0, 10 * scale);
        Font rotatedFont = font.deriveFont(affineTransform);
        Rectangle2D fontBounds = g.getFontMetrics(rotatedFont).getStringBounds("80M", g);
        g.setFont(rotatedFont);
        int fontHeight = (int)fontBounds.getHeight();
        ArrayList<FrequencyBand> bands = this.getFrequencyBands(freqStartHz, freqEndHz);
        float freqRange = freqEndHz - freqStartHz;
        Rectangle2D.Float rect = new Rectangle2D.Float();
        float textOffset = fontHeight;
        float textX = fontHeight / 2;
        class BandRectangle {
            ArrayList<String> lines;
            float x;
            float y;
            float w;
            FrequencyBand band;
            String longestString;
            boolean textVisible = true;

            public BandRectangle(FrequencyBand band, ArrayList<String> lines, float x, float y, float w, String longestString) {
                this.band = band;
                this.lines = lines;
                this.x = x;
                this.y = y;
                this.w = w;
                this.longestString = longestString;
            }
        }
        ArrayList<BandRectangle> shapes = new ArrayList<BandRectangle>(bands.size());
        int j = 0;
        while (j < bands.size()) {
            FrequencyBand band = bands.get(j);
            float xStart = (float)((band.getHzStartIncl() - freqStartHz) * (long)drawWidth) / freqRange;
            float xEnd = (float)((band.getHzEndExcl() - freqStartHz) * (long)drawWidth) / freqRange;
            if (xStart < 0.0f) {
                xStart = 0.0f;
            }
            float x = xStart;
            float y = 0.0f;
            float w = xEnd - xStart;
            String[] lines = band.getName().split("/");
            ArrayList<String> listLines = new ArrayList<String>(lines.length + 1);
            listLines.add(String.format("%d - %dM", band.getHzStartIncl() / 1000000L, band.getHzEndExcl() / 1000000L));
            int line = 0;
            while (line < lines.length) {
                String linestr = lines[line];
                listLines.add(linestr);
                ++line;
            }
            Arrays.sort(lines, (o1, o2) -> Integer.compare(o2.length(), o1.length()));
            shapes.add(new BandRectangle(band, listLines, x, y, w, lines[0]));
            ++j;
        }
        float maxVisibleLines = 1.0f;
        int j2 = 0;
        while (j2 < shapes.size()) {
            BandRectangle shape = (BandRectangle)shapes.get(j2);
            Rectangle2D bounds = g.getFontMetrics(rotatedFont).getStringBounds(shape.lines.get(0), g);
            if ((double)shape.w > bounds.getWidth()) {
                if ((float)shape.lines.size() > maxVisibleLines) {
                    maxVisibleLines = shape.lines.size();
                }
            } else {
                shape.textVisible = false;
            }
            ++j2;
        }
        rect.height = rectHeight = maxVisibleLines * (float)fontHeight + (float)(fontHeight / 2);
        int j3 = 0;
        while (j3 < shapes.size()) {
            BandRectangle shape = (BandRectangle)shapes.get(j3);
            rect.x = shape.x;
            rect.y = shape.y;
            rect.width = shape.w;
            g.setColor(bgColor);
            g.fill(rect);
            g.setColor(Color.black);
            g.draw(rect);
            if (shape.textVisible) {
                g.setColor(textColor);
                Graphics2D gg = (Graphics2D)g.create((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
                int line = 0;
                while (line < shape.lines.size()) {
                    String linestr = shape.lines.get(line);
                    gg.drawString(linestr, textX, textOffset + (float)(line * fontHeight));
                    ++line;
                }
                gg.dispose();
            }
            ++j3;
        }
        g.dispose();
        if (scale > 1) {
            BufferedImage iOut = GraphicsToolkit.createAcceleratedImageTransparent(width, height);
            g = iOut.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.drawImage(i, 0, 0, width, height, null);
            g.dispose();
            return iOut;
        }
        return i;
    }
}

