/*
 * Decompiled with CFR 0.152.
 */
package jspectrumanalyzer.core;

public class EMA {
    private double ema = 0.0;
    private int order;

    public static double calculate(double currentValue, double previousEMA, double order) {
        double k = 2.0 / (order + 1.0);
        double result = currentValue * k + previousEMA * (1.0 - k);
        return result;
    }

    public static double calculateTimeDependent(double currentValue, double previousEMA, long timeDiffFromPreviousValueMillis, double orderInMillis) {
        double order = timeDiffFromPreviousValueMillis <= 0L ? 1.0 : orderInMillis / (double)timeDiffFromPreviousValueMillis;
        double k = 2.0 / (order + 1.0);
        double result = currentValue * k + previousEMA * (1.0 - k);
        return result;
    }

    public EMA(int order) {
        this.order = order;
    }

    public double addNewValue(double value) {
        this.ema = EMA.calculate(value, this.ema, this.order);
        return this.ema;
    }

    public double getEma() {
        return this.ema;
    }
}

