/*
 * Decompiled with CFR 0.152.
 */
package jspectrumanalyzer.core;

import java.util.Arrays;
import jspectrumanalyzer.core.DatasetSpectrum;
import jspectrumanalyzer.core.EMA;
import jspectrumanalyzer.core.jfc.XYSeriesImmutable;
import org.jfree.data.xy.XYSeries;

public class DatasetSpectrumPeak
extends DatasetSpectrum {
    protected long lastAdded = System.currentTimeMillis();
    protected long peakFalloutMillis = 1000L;
    protected float peakFallThreshold;
    protected float[] spectrumPeak;
    protected float[] spectrumPeakHold;
    private long debugLastPeakRerfreshTime = 0L;

    public DatasetSpectrumPeak(float fftBinSizeHz, int freqStartMHz, int freqStopMHz, float spectrumInitPower, float peakFallThreshold, long peakFalloutMillis) {
        super(fftBinSizeHz, freqStartMHz, freqStopMHz, spectrumInitPower);
        this.peakFalloutMillis = peakFalloutMillis;
        this.spectrumInitPower = spectrumInitPower;
        this.peakFallThreshold = peakFallThreshold;
        int datapoints = (int)(Math.ceil(freqStopMHz - freqStartMHz) * 1000000.0 / (double)fftBinSizeHz);
        this.spectrum = new float[datapoints];
        Arrays.fill(this.spectrum, spectrumInitPower);
        this.spectrumPeak = new float[datapoints];
        Arrays.fill(this.spectrumPeak, spectrumInitPower);
        this.spectrumPeakHold = new float[datapoints];
        Arrays.fill(this.spectrumPeakHold, spectrumInitPower);
    }

    public void setPeakFalloutMillis(long peakFalloutMillis) {
        this.peakFalloutMillis = peakFalloutMillis;
    }

    public void copyTo(DatasetSpectrumPeak filtered) {
        super.copyTo(filtered);
        System.arraycopy(this.spectrumPeak, 0, filtered.spectrumPeak, 0, this.spectrumPeak.length);
        System.arraycopy(this.spectrumPeakHold, 0, filtered.spectrumPeakHold, 0, this.spectrumPeakHold.length);
    }

    public void fillPeaksToXYSeries(XYSeries series) {
        this.fillToXYSeriesPriv(series, this.spectrumPeakHold);
    }

    public XYSeriesImmutable createPeaksDataset(String name) {
        float[] xValues = new float[this.spectrum.length];
        float[] yValues = this.spectrumPeakHold;
        int i = 0;
        while (i < this.spectrum.length) {
            float freq;
            xValues[i] = freq = ((float)this.freqStartHz + this.fftBinSizeHz * (float)i) / 1000000.0f;
            ++i;
        }
        XYSeriesImmutable xySeriesF = new XYSeriesImmutable((Comparable)((Object)name), xValues, yValues);
        return xySeriesF;
    }

    public double calculateSpectrumPeakPower() {
        double powerSum = 0.0;
        int i = 0;
        while (i < this.spectrumPeakHold.length) {
            powerSum += Math.pow(10.0, this.spectrumPeakHold[i] / 10.0f);
            ++i;
        }
        powerSum = 10.0 * Math.log10(powerSum);
        return powerSum;
    }

    public void refreshPeakSpectrum() {
        long timeDiffFromPrevValueMillis = System.currentTimeMillis() - this.lastAdded;
        if (timeDiffFromPrevValueMillis < 1L) {
            timeDiffFromPrevValueMillis = 1L;
        }
        this.lastAdded = System.currentTimeMillis();
        int spectrIndex = 0;
        while (spectrIndex < this.spectrum.length) {
            float spectrumVal = this.spectrum[spectrIndex];
            if (spectrumVal > this.spectrumPeakHold[spectrIndex]) {
                this.spectrumPeakHold[spectrIndex] = this.spectrumPeak[spectrIndex] = spectrumVal;
            }
            this.spectrumPeak[spectrIndex] = (float)EMA.calculateTimeDependent(spectrumVal, this.spectrumPeak[spectrIndex], timeDiffFromPrevValueMillis, this.peakFalloutMillis);
            if (this.spectrumPeakHold[spectrIndex] - this.spectrumPeak[spectrIndex] > this.peakFallThreshold) {
                this.spectrumPeakHold[spectrIndex] = this.spectrumPeak[spectrIndex];
            }
            ++spectrIndex;
        }
    }

    public void resetPeaks() {
        Arrays.fill(this.spectrumPeak, this.spectrumInitPower);
        Arrays.fill(this.spectrumPeakHold, this.spectrumInitPower);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        DatasetSpectrumPeak copy = (DatasetSpectrumPeak)super.clone();
        copy.spectrumPeakHold = (float[])this.spectrumPeakHold.clone();
        copy.spectrumPeak = (float[])this.spectrumPeak.clone();
        return super.clone();
    }
}

