/*
 * Decompiled with CFR 0.152.
 */
package jspectrumanalyzer.core;

import java.util.ArrayList;
import java.util.Arrays;
import jspectrumanalyzer.core.FFTBins;
import jspectrumanalyzer.core.jfc.XYSeriesImmutable;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;

public class DatasetSpectrum
implements Cloneable {
    private final boolean useCached = false;
    protected ArrayList<ArrayList<XYDataItem>> cachedDataItems = new ArrayList();
    protected int cachedDataItemsIndex = 0;
    protected final float fftBinSizeHz;
    protected final long freqStartHz;
    protected final int freqStartMHz;
    protected final int freqStopMHz;
    protected float[] spectrum;
    protected float spectrumInitPower;

    public DatasetSpectrum(float fftBinSizeHz, int freqStartMHz, int freqStopMHz, float spectrumInitPower) {
        this.fftBinSizeHz = fftBinSizeHz;
        this.freqStartMHz = freqStartMHz;
        this.freqStartHz = (long)freqStartMHz * 1000000L;
        this.freqStopMHz = freqStopMHz;
        this.spectrumInitPower = spectrumInitPower;
        int datapoints = (int)(Math.ceil(freqStopMHz - freqStartMHz) * 1000000.0 / (double)fftBinSizeHz);
        this.spectrum = new float[datapoints];
        Arrays.fill(this.spectrum, spectrumInitPower);
    }

    public boolean addNewData(FFTBins fftBins) {
        boolean triggerRefresh = false;
        triggerRefresh = fftBins.fullSweepDone;
        int binsIndex = 0;
        while (binsIndex < fftBins.freqStart.length) {
            double freqStart = fftBins.freqStart[binsIndex];
            int spectrIndex = (int)((freqStart - (double)this.freqStartHz) / (double)this.fftBinSizeHz);
            if (spectrIndex >= 0 && spectrIndex < this.spectrum.length) {
                this.spectrum[spectrIndex] = fftBins.sigPowdBm[binsIndex];
            }
            ++binsIndex;
        }
        return triggerRefresh;
    }

    public DatasetSpectrum cloneMe() {
        DatasetSpectrum copy;
        try {
            copy = (DatasetSpectrum)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        return copy;
    }

    public void copyTo(DatasetSpectrum filtered) {
        System.arraycopy(this.spectrum, 0, filtered.spectrum, 0, this.spectrum.length);
    }

    public XYSeriesImmutable createSpectrumDataset(String name) {
        float[] xValues = new float[this.spectrum.length];
        float[] yValues = this.spectrum;
        int i = 0;
        while (i < this.spectrum.length) {
            float freq;
            xValues[i] = freq = ((float)this.freqStartHz + this.fftBinSizeHz * (float)i) / 1000000.0f;
            ++i;
        }
        XYSeriesImmutable xySeriesF = new XYSeriesImmutable((Comparable)((Object)name), xValues, yValues);
        return xySeriesF;
    }

    public void fillToXYSeries(XYSeries series) {
        this.fillToXYSeriesPriv(series, this.spectrum);
    }

    public float getFFTBinSizeHz() {
        return this.fftBinSizeHz;
    }

    public int getFreqStartMHz() {
        return this.freqStartMHz;
    }

    public int getFreqStopMHz() {
        return this.freqStopMHz;
    }

    public double getFrequency(int index) {
        double freq = (float)this.freqStartHz + this.fftBinSizeHz * (float)index;
        return freq;
    }

    public float getPower(int index) {
        return this.spectrum[index];
    }

    public float[] getSpectrumArray() {
        return this.spectrum;
    }

    public void resetSpectrum() {
        Arrays.fill(this.spectrum, this.spectrumInitPower);
    }

    public void setSpectrumInitPower(float spectrumInitPower) {
        this.spectrumInitPower = spectrumInitPower;
    }

    public int spectrumLength() {
        return this.spectrum.length;
    }

    protected Object clone() throws CloneNotSupportedException {
        DatasetSpectrum copy = (DatasetSpectrum)super.clone();
        copy.spectrum = (float[])this.spectrum.clone();
        return copy;
    }

    protected void fillToXYSeriesPriv(XYSeries series, float[] spectrum) {
        series.clear();
        int i = 0;
        while (i < spectrum.length) {
            double freq = ((float)this.freqStartHz + this.fftBinSizeHz * (float)i) / 1000000.0f;
            series.add(freq, (double)spectrum[i]);
            ++i;
        }
    }
}

