/*
 * Decompiled with CFR 0.152.
 */
package jspectrumanalyzer.capture;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jspectrumanalyzer.capture.GifSequenceWriter;

public class ScreenCapture {
    private final JFrame frame;
    private final int width;
    private final int height;
    private final ImageOutputStream output;
    private final GifSequenceWriter gif;
    private final long captureMillis;
    private final File outputFile;
    private long startCaptureTS = 0L;
    private long startedCapture = 0L;
    private long lastFrameTS = 0L;
    private int framesCaptured = 0;
    private ExecutorService saveThread = Executors.newSingleThreadExecutor();
    private long frameIIntervalMS;

    public ScreenCapture(JFrame frame, int initSecs, int captureSecs, int fps, int width, int height, File outputFile) throws FileNotFoundException, IOException {
        this.captureMillis = (long)captureSecs * 1000L;
        this.frame = frame;
        this.width = width;
        this.height = height;
        this.outputFile = outputFile;
        this.startCaptureTS = System.currentTimeMillis() + (long)initSecs * 1000L;
        this.frameIIntervalMS = 1000 / fps;
        frame.setSize(width, height);
        outputFile.delete();
        this.output = new FileImageOutputStream(outputFile);
        this.gif = new GifSequenceWriter(this.output, 5, (int)this.frameIIntervalMS, true);
    }

    public void captureFrame() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Capture is NOT inside event dispatch thread!");
        }
        long start = System.currentTimeMillis();
        if (start - this.lastFrameTS < this.frameIIntervalMS || start < this.startCaptureTS) {
            return;
        }
        this.lastFrameTS = start;
        if (this.framesCaptured == -1) {
            return;
        }
        if (this.framesCaptured == 0) {
            this.startedCapture = System.currentTimeMillis();
            System.out.println("Capture started...");
        }
        if (System.currentTimeMillis() - this.startedCapture >= this.captureMillis) {
            System.out.println("Capture finished... frames captured: " + this.framesCaptured);
            this.framesCaptured = -1;
            try {
                this.gif.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.output.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.exit(0);
            return;
        }
        ++this.framesCaptured;
        BufferedImage capImage = new BufferedImage(this.width, this.height, 5);
        Graphics2D g = (Graphics2D)capImage.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.frame.paint(g);
        g.dispose();
        this.saveThread.submit(() -> {
            try {
                this.gif.writeToSequence(capImage);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        System.out.println("time to save gif " + (System.currentTimeMillis() - start));
    }
}

