/*
 * Decompiled with CFR 0.152.
 */
package jspectrumanalyzer;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jspectrumanalyzer.capture.ScreenCapture;
import jspectrumanalyzer.core.DatasetSpectrumPeak;
import jspectrumanalyzer.core.FFTBins;
import jspectrumanalyzer.core.FrequencyAllocationTable;
import jspectrumanalyzer.core.FrequencyAllocations;
import jspectrumanalyzer.core.FrequencyBand;
import jspectrumanalyzer.core.FrequencyRange;
import jspectrumanalyzer.core.HackRFSettings;
import jspectrumanalyzer.core.PersistentDisplay;
import jspectrumanalyzer.core.SpurFilter;
import jspectrumanalyzer.core.jfc.XYSeriesCollectionImmutable;
import jspectrumanalyzer.core.jfc.XYSeriesImmutable;
import jspectrumanalyzer.nativebridge.HackRFSweepDataCallback;
import jspectrumanalyzer.nativebridge.HackRFSweepNativeBridge;
import jspectrumanalyzer.ui.HackRFSweepSettingsUI;
import jspectrumanalyzer.ui.WaterfallPlot;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.event.OverlayChangeListener;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import shared.mvc.ModelValue;

public class HackRFSweepSpectrumAnalyzer
implements HackRFSettings,
HackRFSweepDataCallback {
    public static final int SPECTRUM_PALETTE_SIZE_MIN = 5;
    private static boolean captureGIF = false;
    private static long initTime = System.currentTimeMillis();
    public boolean flagIsHWSendingData = false;
    private float alphaFreqAllocationTableBandsImage = 0.5f;
    private float alphaPersistentDisplayImage = 1.0f;
    private JFreeChart chart;
    private ModelValue<Rectangle2D> chartDataArea = new ModelValue<Rectangle2D.Double>("Chart data area", new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0));
    private XYSeriesCollectionImmutable chartDataset = new XYSeriesCollectionImmutable();
    private XYLineAndShapeRenderer chartLineRenderer;
    private ChartPanel chartPanel;
    private ColorScheme colors = new ColorScheme();
    private DatasetSpectrumPeak datasetSpectrum;
    private int dropped = 0;
    private volatile boolean flagManualGain = false;
    private volatile boolean forceStopSweep = false;
    private ScreenCapture gifCap = null;
    private ArrayList<HackRFSettings.HackRFEventListener> hRFlisteners = new ArrayList();
    private ArrayBlockingQueue<FFTBins> hwProcessingQueue = new ArrayBlockingQueue(1000);
    private BufferedImage imageFrequencyAllocationTableBands = null;
    private boolean isChartDrawing = false;
    private ReentrantLock lock = new ReentrantLock();
    private ModelValue.ModelValueBoolean parameterAntennaLNA = new ModelValue.ModelValueBoolean("Antenna LNA +14dB", false);
    private ModelValue.ModelValueBoolean parameterAntPower = new ModelValue.ModelValueBoolean("Ant power", false);
    private ModelValue.ModelValueInt parameterFFTBinHz = new ModelValue.ModelValueInt("FFT Bin [Hz]", 100000);
    private ModelValue.ModelValueBoolean parameterFilterSpectrum = new ModelValue.ModelValueBoolean("Filter", false);
    private ModelValue<FrequencyRange> parameterFrequency = new ModelValue<FrequencyRange>("Frequency range", new FrequencyRange(2400, 2500));
    private ModelValue<FrequencyAllocationTable> parameterFrequencyAllocationTable = new ModelValue<Object>("Frequency allocation table", null);
    private ModelValue.ModelValueInt parameterGainLNA = new ModelValue.ModelValueInt("LNA Gain", 0, 8, 0, 40);
    private ModelValue.ModelValueInt parameterGainTotal = new ModelValue.ModelValueInt("Gain [dB]", 40);
    private ModelValue.ModelValueInt parameterGainVGA = new ModelValue.ModelValueInt("VGA Gain", 0, 2, 0, 60);
    private ModelValue.ModelValueBoolean parameterIsCapturingPaused = new ModelValue.ModelValueBoolean("Capturing paused", false);
    private ModelValue.ModelValueInt parameterPersistentDisplayPersTime = new ModelValue.ModelValueInt("Persistence time", 30, 1, 1, 60);
    private ModelValue.ModelValueInt parameterPeakFallRateSecs = new ModelValue.ModelValueInt("Peak fall rate", 30);
    private ModelValue.ModelValueBoolean parameterPersistentDisplay = new ModelValue.ModelValueBoolean("Persistent display", false);
    private ModelValue.ModelValueInt parameterSamples = new ModelValue.ModelValueInt("Samples", 8192);
    private ModelValue.ModelValueBoolean parameterShowPeaks = new ModelValue.ModelValueBoolean("Show peaks", false);
    private ModelValue.ModelValueBoolean parameterDebugDisplay = new ModelValue.ModelValueBoolean("Debug", false);
    private ModelValue<BigDecimal> parameterSpectrumLineThickness = new ModelValue<BigDecimal>("Spectrum line thickness", new BigDecimal("1"));
    private ModelValue.ModelValueInt parameterSpectrumPaletteSize = new ModelValue.ModelValueInt("Spectrum palette size", 0);
    private ModelValue.ModelValueInt parameterSpectrumPaletteStart = new ModelValue.ModelValueInt("Spectrum palette start", 0);
    private ModelValue.ModelValueBoolean parameterSpurRemoval = new ModelValue.ModelValueBoolean("Spur removal", false);
    private ModelValue.ModelValueBoolean parameterWaterfallVisible = new ModelValue.ModelValueBoolean("Waterfall visible", true);
    private PersistentDisplay persistentDisplay = new PersistentDisplay();
    private float spectrumInitValue = -150.0f;
    private SpurFilter spurFilter;
    private Thread threadHackrfSweep;
    private ArrayBlockingQueue<Integer> threadLaunchCommands = new ArrayBlockingQueue(1);
    private Thread threadLauncher;
    private Thread threadProcessing;
    private TextTitle titleFreqBand = new TextTitle("", new Font("Dialog", 0, 11));
    private RuntimePerformanceWatch perfWatch = new RuntimePerformanceWatch();
    private JFrame uiFrame;
    private ValueMarker waterfallPaletteEndMarker;
    private ValueMarker waterfallPaletteStartMarker;
    private WaterfallPlot waterfallPlot;
    private JLabel labelMessages;

    public static void main(String[] args) throws IOException {
        if (args.length > 0 && args[0].equals("capturegif")) {
            captureGIF = true;
        }
        new HackRFSweepSpectrumAnalyzer();
    }

    public HackRFSweepSpectrumAnalyzer() {
        this.printInit(0);
        if (captureGIF) {
            this.parameterFrequency.setValue(new FrequencyRange(2400, 2700));
            this.parameterGainTotal.setValue(60);
            this.parameterSpurRemoval.setValue(true);
            this.parameterPersistentDisplay.setValue(true);
            this.parameterFFTBinHz.setValue(500000);
            this.parameterFrequencyAllocationTable.setValue(new FrequencyAllocations().getTable().values().stream().findFirst().get());
        }
        this.recalculateGains((Integer)this.parameterGainTotal.getValue());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        Insets insets = new Insets(1, 1, 1, 1);
        UIManager.getLookAndFeelDefaults().put("TabbedPane.contentBorderInsets", insets);
        UIManager.getLookAndFeelDefaults().put("TabbedPane.selectedTabPadInsets", insets);
        UIManager.getLookAndFeelDefaults().put("TabbedPane.tabAreaInsets", insets);
        this.setupChart();
        this.setupChartMouseMarkers();
        this.waterfallPlot = new WaterfallPlot(this.chartPanel, 300);
        this.waterfallPaletteStartMarker = new ValueMarker(this.waterfallPlot.getSpectrumPaletteStart(), (Paint)this.colors.palette2, (Stroke)new BasicStroke(1.0f));
        this.waterfallPaletteEndMarker = new ValueMarker(this.waterfallPlot.getSpectrumPaletteStart() + this.waterfallPlot.getSpectrumPaletteSize(), (Paint)this.colors.palette2, (Stroke)new BasicStroke(1.0f));
        this.printInit(2);
        HackRFSweepSettingsUI settingsPanel = new HackRFSweepSettingsUI(this);
        this.printInit(3);
        JSplitPane splitPane = new JSplitPane(0, (Component)this.chartPanel, this.waterfallPlot);
        splitPane.setResizeWeight(0.8);
        splitPane.setBorder(null);
        this.labelMessages = new JLabel("dsadasd");
        this.labelMessages.setForeground(Color.white);
        this.labelMessages.setFont(new Font("Monospaced", 0, 12));
        this.parameterDebugDisplay.addListener(debug -> this.labelMessages.setVisible((boolean)debug));
        this.parameterDebugDisplay.callObservers();
        JPanel splitPanePanel = new JPanel(new BorderLayout());
        splitPanePanel.setBackground(Color.black);
        splitPanePanel.add((Component)splitPane, "Center");
        splitPanePanel.add((Component)this.labelMessages, "South");
        this.uiFrame = new JFrame();
        this.uiFrame.setUndecorated(captureGIF);
        this.uiFrame.setExtendedState(this.uiFrame.getExtendedState() | 6);
        this.uiFrame.setDefaultCloseOperation(3);
        this.uiFrame.setLayout(new BorderLayout());
        this.uiFrame.setTitle("Spectrum Analyzer - hackrf_sweep");
        this.uiFrame.add((Component)splitPanePanel, "Center");
        this.uiFrame.setMinimumSize(new Dimension(600, 600));
        this.uiFrame.add((Component)settingsPanel, "East");
        try {
            this.uiFrame.setIconImage(new ImageIcon("program.png").getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.printInit(4);
        this.setupFrequencyAllocationTable();
        this.printInit(5);
        this.uiFrame.pack();
        this.uiFrame.setVisible(true);
        this.printInit(6);
        this.startLauncherThread();
        this.restartHackrfSweep();
        this.setupParameterObservers();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.stopHackrfSweep()));
        if (captureGIF) {
            try {
                this.gifCap = new ScreenCapture(this.uiFrame, 35, 10, 5, 760, 660, new File("screenshot.gif"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ModelValue.ModelValueBoolean getAntennaPowerEnable() {
        return this.parameterAntPower;
    }

    @Override
    public ModelValue.ModelValueInt getFFTBinHz() {
        return this.parameterFFTBinHz;
    }

    @Override
    public ModelValue<FrequencyRange> getFrequency() {
        return this.parameterFrequency;
    }

    @Override
    public ModelValue<FrequencyAllocationTable> getFrequencyAllocationTable() {
        return this.parameterFrequencyAllocationTable;
    }

    @Override
    public ModelValue.ModelValueInt getGain() {
        return this.parameterGainTotal;
    }

    @Override
    public ModelValue.ModelValueInt getGainLNA() {
        return this.parameterGainLNA;
    }

    @Override
    public ModelValue.ModelValueInt getGainVGA() {
        return this.parameterGainVGA;
    }

    @Override
    public ModelValue.ModelValueBoolean getAntennaLNA() {
        return this.parameterAntennaLNA;
    }

    @Override
    public ModelValue.ModelValueInt getPeakFallRate() {
        return this.parameterPeakFallRateSecs;
    }

    @Override
    public ModelValue.ModelValueInt getSamples() {
        return this.parameterSamples;
    }

    @Override
    public ModelValue<BigDecimal> getSpectrumLineThickness() {
        return this.parameterSpectrumLineThickness;
    }

    @Override
    public ModelValue.ModelValueInt getPersistentDisplayDecayRate() {
        return this.parameterPersistentDisplayPersTime;
    }

    @Override
    public ModelValue.ModelValueInt getSpectrumPaletteSize() {
        return this.parameterSpectrumPaletteSize;
    }

    @Override
    public ModelValue.ModelValueInt getSpectrumPaletteStart() {
        return this.parameterSpectrumPaletteStart;
    }

    @Override
    public ModelValue.ModelValueBoolean isCapturingPaused() {
        return this.parameterIsCapturingPaused;
    }

    @Override
    public ModelValue.ModelValueBoolean isChartsPeaksVisible() {
        return this.parameterShowPeaks;
    }

    @Override
    public ModelValue.ModelValueBoolean isDebugDisplay() {
        return this.parameterDebugDisplay;
    }

    @Override
    public ModelValue.ModelValueBoolean isFilterSpectrum() {
        return this.parameterFilterSpectrum;
    }

    @Override
    public ModelValue.ModelValueBoolean isPersistentDisplayVisible() {
        return this.parameterPersistentDisplay;
    }

    @Override
    public ModelValue.ModelValueBoolean isSpurRemoval() {
        return this.parameterSpurRemoval;
    }

    @Override
    public ModelValue.ModelValueBoolean isWaterfallVisible() {
        return this.parameterWaterfallVisible;
    }

    @Override
    public void newSpectrumData(boolean fullSweepDone, double[] frequencyStart, float fftBinWidthHz, float[] signalPowerdBm) {
        this.fireHardwareStateChanged(true);
        if (!this.hwProcessingQueue.offer(new FFTBins(fullSweepDone, frequencyStart, fftBinWidthHz, signalPowerdBm))) {
            System.out.println("queue full");
            ++this.dropped;
        }
    }

    @Override
    public void registerListener(HackRFSettings.HackRFEventListener listener) {
        this.hRFlisteners.add(listener);
    }

    @Override
    public void removeListener(HackRFSettings.HackRFEventListener listener) {
        this.hRFlisteners.remove(listener);
    }

    private void fireCapturingStateChanged() {
        SwingUtilities.invokeLater(() -> {
            ArrayList<HackRFSettings.HackRFEventListener> arrayList = this.hRFlisteners;
            synchronized (arrayList) {
                for (HackRFSettings.HackRFEventListener hackRFEventListener : this.hRFlisteners) {
                    try {
                        hackRFEventListener.captureStateChanged((Boolean)this.parameterIsCapturingPaused.getValue() == false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void fireHardwareStateChanged(boolean sendingData) {
        if (this.flagIsHWSendingData != sendingData) {
            this.flagIsHWSendingData = sendingData;
            SwingUtilities.invokeLater(() -> {
                ArrayList<HackRFSettings.HackRFEventListener> arrayList = this.hRFlisteners;
                synchronized (arrayList) {
                    for (HackRFSettings.HackRFEventListener hackRFEventListener : this.hRFlisteners) {
                        try {
                            hackRFEventListener.hardwareStatusChanged(sendingData);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    private FrequencyRange getFreq() {
        return this.parameterFrequency.getValue();
    }

    private void printInit(int initNumber) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processingThread() {
        long counter = 0L;
        long frameCounterChart = 0L;
        FFTBins bin1 = null;
        try {
            bin1 = this.hwProcessingQueue.take();
        }
        catch (InterruptedException e1) {
            return;
        }
        float binHz = bin1.fftBinWidthHz;
        int limitChartRefreshFPS = 30;
        int limitPersistentRefreshEveryChartFrame = 2;
        this.datasetSpectrum = new DatasetSpectrumPeak(binHz, this.getFreq().getStartMHz(), this.getFreq().getEndMHz(), this.spectrumInitValue, 15.0f, (Integer)this.parameterPeakFallRateSecs.getValue() * 1000);
        this.chart.getXYPlot().getDomainAxis().setRange((double)this.getFreq().getStartMHz(), (double)this.getFreq().getEndMHz());
        XYSeries spectrumPeaksEmpty = new XYSeries((Comparable)((Object)"peaks"));
        float maxPeakJitterdB = 6.0f;
        float peakThresholdAboveNoise = 4.0f;
        int maxPeakBins = 4;
        int validIterations = 25;
        this.spurFilter = new SpurFilter(maxPeakJitterdB, peakThresholdAboveNoise, maxPeakBins, validIterations, this.datasetSpectrum);
        long lastChartUpdated = System.currentTimeMillis();
        long lastScanStartTime = System.currentTimeMillis();
        double lastFreq = 0.0;
        try {
            while (true) {
                long start;
                ++counter;
                FFTBins bins = this.hwProcessingQueue.take();
                if (((Boolean)this.parameterIsCapturingPaused.getValue()).booleanValue()) continue;
                boolean triggerChartRefresh = bins.fullSweepDone;
                if (bins.freqStart != null && bins.sigPowdBm != null) {
                    this.datasetSpectrum.addNewData(bins);
                }
                if (!triggerChartRefresh) continue;
                if (((Boolean)this.parameterSpurRemoval.getValue()).booleanValue()) {
                    long start2 = System.nanoTime();
                    this.spurFilter.filterDataset();
                    RuntimePerformanceWatch runtimePerformanceWatch = this.perfWatch;
                    synchronized (runtimePerformanceWatch) {
                        this.perfWatch.spurFilter.addDrawingTime(System.nanoTime() - start2);
                    }
                }
                if (((Boolean)this.parameterShowPeaks.getValue()).booleanValue()) {
                    this.datasetSpectrum.refreshPeakSpectrum();
                    this.waterfallPlot.setStatusMessage(String.format("Total Spectrum Peak Power %.1fdBm", this.datasetSpectrum.calculateSpectrumPeakPower()), 0);
                }
                if (System.currentTimeMillis() - this.perfWatch.lastStatisticsRefreshed > 1000L) {
                    RuntimePerformanceWatch start2 = this.perfWatch;
                    synchronized (start2) {
                        this.perfWatch.waterfallDraw.nanosSum = this.waterfallPlot.getDrawTimeSumAndReset();
                        this.perfWatch.waterfallDraw.count = this.waterfallPlot.getDrawingCounterAndReset();
                        String stats = this.perfWatch.generateStatistics();
                        SwingUtilities.invokeLater(() -> this.labelMessages.setText(stats));
                        this.perfWatch.reset();
                    }
                }
                boolean flagChartRedraw = false;
                if (System.currentTimeMillis() - lastChartUpdated > (long)(1000 / limitChartRefreshFPS)) {
                    flagChartRedraw = true;
                    ++frameCounterChart;
                    lastChartUpdated = System.currentTimeMillis();
                }
                XYSeriesImmutable spectrumSeries = this.datasetSpectrum.createSpectrumDataset("spectrum");
                XYSeries spectrumPeaks = (Boolean)this.parameterShowPeaks.getValue() != false ? this.datasetSpectrum.createPeaksDataset("peaks") : spectrumPeaksEmpty;
                if (((Boolean)this.parameterPersistentDisplay.getValue()).booleanValue()) {
                    start = System.nanoTime();
                    boolean redraw = false;
                    if (flagChartRedraw && frameCounterChart % (long)limitPersistentRefreshEveryChartFrame == 0L) {
                        redraw = true;
                    }
                    this.persistentDisplay.drawSpectrum2(this.datasetSpectrum, (float)this.chart.getXYPlot().getRangeAxis().getRange().getLowerBound(), (float)this.chart.getXYPlot().getRangeAxis().getRange().getUpperBound(), redraw);
                    RuntimePerformanceWatch runtimePerformanceWatch = this.perfWatch;
                    synchronized (runtimePerformanceWatch) {
                        this.perfWatch.persisentDisplay.addDrawingTime(System.nanoTime() - start);
                    }
                }
                if (((Boolean)this.parameterWaterfallVisible.getValue()).booleanValue()) {
                    start = System.nanoTime();
                    this.waterfallPlot.addNewData(this.datasetSpectrum);
                    RuntimePerformanceWatch runtimePerformanceWatch = this.perfWatch;
                    synchronized (runtimePerformanceWatch) {
                        this.perfWatch.waterfallUpdate.addDrawingTime(System.nanoTime() - start);
                    }
                }
                if (flagChartRedraw) {
                    if (((Boolean)this.parameterWaterfallVisible.getValue()).booleanValue()) {
                        this.waterfallPlot.repaint();
                    }
                    SwingUtilities.invokeLater(() -> {
                        this.chart.setNotify(false);
                        this.chartDataset.removeAllSeries();
                        this.chartDataset.addSeries(spectrumPeaks);
                        this.chartDataset.addSeries(spectrumSeries);
                        this.chart.setNotify(true);
                        if (this.gifCap != null) {
                            this.gifCap.captureFrame();
                        }
                    });
                }
                RuntimePerformanceWatch runtimePerformanceWatch = this.perfWatch;
                synchronized (runtimePerformanceWatch) {
                    ++this.perfWatch.hwFullSpectrumRefreshes;
                }
                counter = 0L;
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private void recalculateGains(int totalGain) {
        int lnaGain = totalGain / 8 * 8;
        if (lnaGain > 40) {
            lnaGain = 40;
        }
        int vgaGain = lnaGain != 40 ? 0 : totalGain - lnaGain & 0xFFFFFFFE;
        this.parameterGainLNA.setValue(lnaGain);
        this.parameterGainVGA.setValue(vgaGain);
        this.parameterGainTotal.setValue(lnaGain + vgaGain);
    }

    private synchronized void restartHackrfSweep() {
        if (!this.threadLaunchCommands.offer(0)) {
            this.threadLaunchCommands.clear();
            this.threadLaunchCommands.offer(0);
        }
    }

    private void restartHackrfSweepExecute() {
        this.stopHackrfSweep();
        this.threadHackrfSweep = new Thread(() -> {
            Thread.currentThread().setName("hackrf_sweep");
            try {
                this.forceStopSweep = false;
                this.sweep();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        this.threadHackrfSweep.start();
    }

    private void setupChart() {
        int axisWidthLeft = 70;
        int axisWidthRight = 20;
        this.chart = ChartFactory.createXYLineChart((String)"Spectrum analyzer", (String)"Frequency [MHz]", (String)"Power [dB]", (XYDataset)this.chartDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        this.chart.getRenderingHints().put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        final XYPlot plot = this.chart.getXYPlot();
        NumberAxis domainAxis = (NumberAxis)plot.getDomainAxis();
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        this.chartLineRenderer = new XYLineAndShapeRenderer();
        this.chartLineRenderer.setBaseShapesVisible(false);
        this.chartLineRenderer.setBaseStroke((Stroke)new BasicStroke(this.parameterSpectrumLineThickness.getValue().floatValue()));
        rangeAxis.setAutoRange(false);
        rangeAxis.setRange(-110.0, 20.0);
        rangeAxis.setTickUnit(new NumberTickUnit(10.0, (NumberFormat)new DecimalFormat("###")));
        domainAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat(" #.### "));
        this.chartLineRenderer.setAutoPopulateSeriesStroke(false);
        this.chartLineRenderer.setAutoPopulateSeriesPaint(false);
        this.chartLineRenderer.setSeriesPaint(0, (Paint)this.colors.palette2);
        plot.setDomainGridlinesVisible(false);
        plot.setRenderer((XYItemRenderer)this.chartLineRenderer);
        AxisSpace axisSpace = new AxisSpace();
        axisSpace.setLeft((double)axisWidthLeft);
        axisSpace.setRight((double)axisWidthRight);
        axisSpace.setTop(0.0);
        axisSpace.setBottom(50.0);
        plot.setFixedDomainAxisSpace(axisSpace);
        plot.setFixedRangeAxisSpace(axisSpace);
        rangeAxis.setAxisLineVisible(false);
        rangeAxis.setTickMarksVisible(false);
        plot.setAxisOffset(RectangleInsets.ZERO_INSETS);
        Font labelFont = new Font("Monospaced", 1, 16);
        rangeAxis.setLabelFont(labelFont);
        rangeAxis.setTickLabelFont(labelFont);
        rangeAxis.setLabelPaint((Paint)this.colors.palette1);
        rangeAxis.setTickLabelPaint((Paint)this.colors.palette1);
        domainAxis.setLabelFont(labelFont);
        domainAxis.setTickLabelFont(labelFont);
        domainAxis.setLabelPaint((Paint)this.colors.palette1);
        domainAxis.setTickLabelPaint((Paint)this.colors.palette1);
        this.chartLineRenderer.setBasePaint((Paint)Color.white);
        plot.setBackgroundPaint((Paint)this.colors.palette4);
        this.chart.setBackgroundPaint((Paint)this.colors.palette4);
        this.chartLineRenderer.setSeriesPaint(1, (Paint)this.colors.palette1);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setMaximumDrawWidth(4096);
        this.chartPanel.setMaximumDrawHeight(2160);
        this.chartPanel.setMouseWheelEnabled(false);
        this.chartPanel.setDomainZoomable(false);
        this.chartPanel.setRangeZoomable(false);
        this.chartPanel.setPopupMenu(null);
        this.chartPanel.setMinimumSize(new Dimension(200, 200));
        this.printInit(1);
        this.chartPanel.addOverlay(new Overlay(){

            public void addChangeListener(OverlayChangeListener listener) {
            }

            public void paintOverlay(Graphics2D g, ChartPanel chartPanel) {
                Rectangle2D area = chartPanel.getChartRenderingInfo().getPlotInfo().getDataArea();
                int plotStartX = (int)area.getX();
                int plotWidth = (int)area.getWidth();
                Rectangle2D subplotArea = chartPanel.getChartRenderingInfo().getPlotInfo().getDataArea();
                int y1 = (int)plot.getRangeAxis().valueToJava2D(HackRFSweepSpectrumAnalyzer.this.waterfallPlot.getSpectrumPaletteStart(), subplotArea, plot.getRangeAxisEdge());
                int y2 = (int)plot.getRangeAxis().valueToJava2D(HackRFSweepSpectrumAnalyzer.this.waterfallPlot.getSpectrumPaletteStart() + HackRFSweepSpectrumAnalyzer.this.waterfallPlot.getSpectrumPaletteSize(), subplotArea, plot.getRangeAxisEdge());
                int x = plotStartX + plotWidth;
                int w = 15;
                int h = y1 - y2;
                HackRFSweepSpectrumAnalyzer.this.waterfallPlot.drawScale(g, x, y2, w, h);
            }

            public void removeChangeListener(OverlayChangeListener listener) {
            }
        });
        this.chartPanel.addOverlay(new Overlay(){

            public void addChangeListener(OverlayChangeListener listener) {
            }

            public void paintOverlay(Graphics2D g2, ChartPanel chartPanel) {
                BufferedImage img = HackRFSweepSpectrumAnalyzer.this.imageFrequencyAllocationTableBands;
                if (img != null) {
                    Rectangle2D area = chartPanel.getChartRenderingInfo().getPlotInfo().getDataArea();
                    g2.drawImage((Image)img, (int)area.getX(), (int)area.getY(), null);
                }
            }

            public void removeChangeListener(OverlayChangeListener listener) {
            }
        });
        this.chart.addChangeListener(event -> {
            Rectangle2D aN = this.chartPanel.getChartRenderingInfo().getPlotInfo().getDataArea();
            Rectangle2D aO = this.chartDataArea.getValue();
            if (aO.getX() != aN.getX() || aO.getY() != aN.getY() || aO.getWidth() != aN.getWidth() || aO.getHeight() != aN.getHeight()) {
                this.chartDataArea.setValue(new Rectangle2D.Double(aN.getX(), aN.getY(), aN.getWidth(), aN.getHeight()));
            }
        });
        this.chart.addProgressListener(new ChartProgressListener(){
            private long chartRedrawStarted;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void chartProgress(ChartProgressEvent arg0) {
                if (arg0.getType() == 1) {
                    this.chartRedrawStarted = System.nanoTime();
                } else if (arg0.getType() == 2) {
                    RuntimePerformanceWatch runtimePerformanceWatch = HackRFSweepSpectrumAnalyzer.this.perfWatch;
                    synchronized (runtimePerformanceWatch) {
                        ((HackRFSweepSpectrumAnalyzer)HackRFSweepSpectrumAnalyzer.this).perfWatch.chartDrawing.addDrawingTime(System.nanoTime() - this.chartRedrawStarted);
                    }
                }
            }
        });
    }

    private void setupChartMouseMarkers() {
        final ValueMarker freqMarker = new ValueMarker(0.0, (Paint)Color.WHITE, (Stroke)new BasicStroke(1.0f));
        freqMarker.setLabelPaint((Paint)Color.white);
        freqMarker.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        freqMarker.setLabelTextAnchor(TextAnchor.TOP_LEFT);
        freqMarker.setLabelFont(new Font("Monospaced", 1, 16));
        final ValueMarker signalMarker = new ValueMarker(0.0, (Paint)Color.WHITE, (Stroke)new BasicStroke(1.0f));
        signalMarker.setLabelPaint((Paint)Color.white);
        signalMarker.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        signalMarker.setLabelTextAnchor(TextAnchor.BOTTOM_RIGHT);
        signalMarker.setLabelFont(new Font("Monospaced", 1, 16));
        this.chartPanel.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){
            DecimalFormat format = new DecimalFormat("0.#");

            @Override
            public void mouseMoved(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                XYPlot plot = HackRFSweepSpectrumAnalyzer.this.chart.getXYPlot();
                Rectangle2D subplotArea = HackRFSweepSpectrumAnalyzer.this.chartPanel.getChartRenderingInfo().getPlotInfo().getDataArea();
                double crosshairRange = plot.getRangeAxis().java2DToValue((double)y, subplotArea, plot.getRangeAxisEdge());
                signalMarker.setValue(crosshairRange);
                signalMarker.setLabel(String.format("%.1fdB", crosshairRange));
                double crosshairDomain = plot.getDomainAxis().java2DToValue((double)x, subplotArea, plot.getDomainAxisEdge());
                freqMarker.setValue(crosshairDomain);
                freqMarker.setLabel(String.format("%.1fMHz", crosshairDomain));
                FrequencyAllocationTable activeTable = (FrequencyAllocationTable)HackRFSweepSpectrumAnalyzer.this.parameterFrequencyAllocationTable.getValue();
                if (activeTable != null) {
                    FrequencyBand band = activeTable.lookupBand((long)(crosshairDomain * 1000000.0));
                    if (band == null) {
                        HackRFSweepSpectrumAnalyzer.this.titleFreqBand.setText(" ");
                    } else {
                        HackRFSweepSpectrumAnalyzer.this.titleFreqBand.setText(String.format("%s - %s MHz  %s", this.format.format(band.getMHzStartIncl()), this.format.format(band.getMHzEndExcl()), band.getApplications().replaceAll("/", " / ")));
                    }
                }
            }
        });
        this.chartPanel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                HackRFSweepSpectrumAnalyzer.this.chart.getXYPlot().clearDomainMarkers();
                HackRFSweepSpectrumAnalyzer.this.chart.getXYPlot().clearRangeMarkers();
                HackRFSweepSpectrumAnalyzer.this.chart.getXYPlot().addRangeMarker((Marker)signalMarker);
                HackRFSweepSpectrumAnalyzer.this.chart.getXYPlot().addDomainMarker((Marker)freqMarker);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                HackRFSweepSpectrumAnalyzer.this.chart.getXYPlot().clearDomainMarkers();
                HackRFSweepSpectrumAnalyzer.this.chart.getXYPlot().clearRangeMarkers();
                HackRFSweepSpectrumAnalyzer.this.titleFreqBand.setText(" ");
            }
        });
        this.titleFreqBand.setFont(new Font("SansSerif", 1, 14));
        this.titleFreqBand.setPosition(RectangleEdge.BOTTOM);
        this.titleFreqBand.setHorizontalAlignment(HorizontalAlignment.LEFT);
        this.titleFreqBand.setMargin(0.0, 2.0, 0.0, 2.0);
        this.titleFreqBand.setPaint((Paint)Color.white);
        this.chart.addSubtitle((Title)this.titleFreqBand);
    }

    private void setupFrequencyAllocationTable() {
        SwingUtilities.invokeLater(() -> {
            this.chartPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    HackRFSweepSpectrumAnalyzer.this.redrawFrequencySpectrumTable();
                }
            });
            this.chart.getXYPlot().getDomainAxis().addChangeListener(e -> this.redrawFrequencySpectrumTable());
            this.chart.getXYPlot().getRangeAxis().addChangeListener(event -> {
                this.redrawFrequencySpectrumTable();
                System.out.println(event);
            });
        });
        this.parameterFrequencyAllocationTable.addListener(this::redrawFrequencySpectrumTable);
    }

    private void setupParameterObservers() {
        Runnable restartHackrf = this::restartHackrfSweep;
        this.parameterFrequency.addListener(restartHackrf);
        this.parameterAntPower.addListener(restartHackrf);
        this.parameterAntennaLNA.addListener(restartHackrf);
        this.parameterFFTBinHz.addListener(restartHackrf);
        this.parameterSamples.addListener(restartHackrf);
        this.parameterIsCapturingPaused.addListener(this::fireCapturingStateChanged);
        this.parameterGainTotal.addListener(gainTotal -> {
            if (this.flagManualGain) {
                return;
            }
            this.recalculateGains((int)gainTotal);
            this.restartHackrfSweep();
        });
        Runnable gainRecalc = () -> {
            block5: {
                int totalGain = (Integer)this.parameterGainLNA.getValue() + (Integer)this.parameterGainVGA.getValue();
                this.flagManualGain = true;
                try {
                    try {
                        this.parameterGainTotal.setValue(totalGain);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.flagManualGain = false;
                        break block5;
                    }
                }
                catch (Throwable throwable) {
                    this.flagManualGain = false;
                    throw throwable;
                }
                this.flagManualGain = false;
            }
            this.restartHackrfSweep();
        };
        this.parameterGainLNA.addListener(gainRecalc);
        this.parameterGainVGA.addListener(gainRecalc);
        this.parameterSpurRemoval.addListener(() -> {
            SpurFilter filter = this.spurFilter;
            if (filter != null) {
                filter.recalibrate();
            }
        });
        this.parameterShowPeaks.addListener(() -> {
            DatasetSpectrumPeak p = this.datasetSpectrum;
            if (p != null) {
                p.resetPeaks();
            }
        });
        this.parameterSpectrumPaletteStart.setValue((int)this.waterfallPlot.getSpectrumPaletteStart());
        this.parameterSpectrumPaletteSize.setValue((int)this.waterfallPlot.getSpectrumPaletteSize());
        this.parameterSpectrumPaletteStart.addListener(dB -> {
            this.waterfallPlot.setSpectrumPaletteStart((int)dB);
            SwingUtilities.invokeLater(() -> {
                this.waterfallPaletteStartMarker.setValue(this.waterfallPlot.getSpectrumPaletteStart());
                this.waterfallPaletteEndMarker.setValue(this.waterfallPlot.getSpectrumPaletteStart() + this.waterfallPlot.getSpectrumPaletteSize());
            });
        });
        this.parameterSpectrumPaletteSize.addListener(dB -> {
            if (dB < 5) {
                return;
            }
            this.waterfallPlot.setSpectrumPaletteSize((int)dB);
            SwingUtilities.invokeLater(() -> {
                this.waterfallPaletteStartMarker.setValue(this.waterfallPlot.getSpectrumPaletteStart());
                this.waterfallPaletteEndMarker.setValue(this.waterfallPlot.getSpectrumPaletteStart() + this.waterfallPlot.getSpectrumPaletteSize());
            });
        });
        this.parameterPeakFallRateSecs.addListener(fallRate -> this.datasetSpectrum.setPeakFalloutMillis((long)fallRate.intValue() * 1000L));
        this.parameterSpectrumLineThickness.addListener(thickness -> SwingUtilities.invokeLater(() -> this.chartLineRenderer.setBaseStroke((Stroke)new BasicStroke(thickness.floatValue()))));
        this.parameterPersistentDisplayPersTime.addListener(time -> this.persistentDisplay.setPersistenceTime((int)time));
        int persistentDisplayDownscaleFactor = 4;
        final Runnable resetPersistentImage = () -> {
            boolean display = (Boolean)this.parameterPersistentDisplay.getValue();
            this.persistentDisplay.reset();
            this.chart.getXYPlot().setBackgroundImage(display ? (Image)this.persistentDisplay.getDisplayImage().getValue() : null);
            this.chart.getXYPlot().setBackgroundImageAlpha(this.alphaPersistentDisplayImage);
        };
        this.persistentDisplay.getDisplayImage().addListener(image -> {
            if (((Boolean)this.parameterPersistentDisplay.getValue()).booleanValue()) {
                this.chart.getXYPlot().setBackgroundImage((Image)image);
            }
        });
        this.registerListener(new HackRFSettings.HackRFEventAdapter(){

            @Override
            public void hardwareStatusChanged(boolean hardwareSendingData) {
                SwingUtilities.invokeLater(() -> {
                    if (hardwareSendingData && ((Boolean)HackRFSweepSpectrumAnalyzer.this.parameterPersistentDisplay.getValue()).booleanValue()) {
                        resetPersistentImage.run();
                    }
                });
            }
        });
        this.parameterPersistentDisplay.addListener(display -> SwingUtilities.invokeLater(resetPersistentImage::run));
        this.chartDataArea.addListener(area -> SwingUtilities.invokeLater(() -> {
            if (this.waterfallPlot != null) {
                this.waterfallPlot.setDrawingOffsets((int)area.getX(), (int)area.getWidth());
            }
            this.persistentDisplay.setImageSize((int)area.getWidth() / persistentDisplayDownscaleFactor, (int)area.getWidth() / persistentDisplayDownscaleFactor);
            if (((Boolean)this.parameterPersistentDisplay.getValue()).booleanValue()) {
                this.chart.getXYPlot().setBackgroundImage((Image)this.persistentDisplay.getDisplayImage().getValue());
                this.chart.getXYPlot().setBackgroundImageAlpha(this.alphaPersistentDisplayImage);
            }
        }));
    }

    private void startLauncherThread() {
        this.threadLauncher = new Thread(() -> {
            Thread.currentThread().setName("Launcher-thread");
            while (true) {
                try {
                    while (true) {
                        this.threadLaunchCommands.take();
                        this.restartHackrfSweepExecute();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        });
        this.threadLauncher.start();
    }

    private void stopHackrfSweep() {
        this.forceStopSweep = true;
        if (this.threadHackrfSweep != null) {
            while (this.threadHackrfSweep.isAlive()) {
                this.forceStopSweep = true;
                HackRFSweepNativeBridge.stop();
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                this.threadHackrfSweep.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.threadHackrfSweep = null;
        }
        System.out.println("HackRFSweep thread stopped.");
        if (this.threadProcessing != null) {
            this.threadProcessing.interrupt();
            try {
                this.threadProcessing.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.threadProcessing = null;
            System.out.println("Processing thread stopped.");
        }
    }

    private void sweep() throws IOException {
        this.lock.lock();
        try {
            try {
                this.threadProcessing = new Thread(() -> {
                    Thread.currentThread().setName("hackrf_sweep data processing thread");
                    this.processingThread();
                });
                this.threadProcessing.start();
                while (!this.forceStopSweep) {
                    System.out.println("Starting hackrf_sweep... " + this.getFreq().getStartMHz() + "-" + this.getFreq().getEndMHz() + "MHz ");
                    System.out.println("hackrf_sweep params:  freq " + this.getFreq().getStartMHz() + "-" + this.getFreq().getEndMHz() + "MHz  FFTBin " + this.parameterFFTBinHz.getValue() + "Hz  samples " + this.parameterSamples.getValue() + "  lna: " + this.parameterGainLNA.getValue() + " vga: " + this.parameterGainVGA.getValue() + " antenna_lna: " + this.parameterAntennaLNA.getValue());
                    this.fireHardwareStateChanged(false);
                    HackRFSweepNativeBridge.start(this, this.getFreq().getStartMHz(), this.getFreq().getEndMHz(), (Integer)this.parameterFFTBinHz.getValue(), (Integer)this.parameterSamples.getValue(), (Integer)this.parameterGainLNA.getValue(), (Integer)this.parameterGainVGA.getValue(), (Boolean)this.parameterAntPower.getValue(), (Boolean)this.parameterAntennaLNA.getValue());
                    this.fireHardwareStateChanged(false);
                    if (this.forceStopSweep) continue;
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.lock.unlock();
                this.fireHardwareStateChanged(false);
            }
        }
        finally {
            this.lock.unlock();
            this.fireHardwareStateChanged(false);
        }
    }

    protected void redrawFrequencySpectrumTable() {
        Rectangle2D area = this.chartPanel.getChartRenderingInfo().getPlotInfo().getDataArea();
        FrequencyAllocationTable activeTable = this.parameterFrequencyAllocationTable.getValue();
        if (activeTable == null) {
            this.imageFrequencyAllocationTableBands = null;
        } else if (area.getWidth() > 0.0 && area.getHeight() > 0.0) {
            this.imageFrequencyAllocationTableBands = activeTable.drawAllocationTable((int)area.getWidth(), (int)area.getHeight(), this.alphaFreqAllocationTableBandsImage, (long)this.getFreq().getStartMHz() * 1000000L, (long)this.getFreq().getEndMHz() * 1000000L, Color.white, Color.DARK_GRAY);
        }
    }

    protected static class ColorScheme {
        Color palette0 = Color.white;
        Color palette1 = new Color(0xE5E5E5);
        Color palette2 = new Color(16556817);
        Color palette3 = new Color(1319229);
        Color palette4 = Color.BLACK;

        protected ColorScheme() {
        }
    }

    private static class PerformanceEntry {
        final String name;
        long nanosSum;
        int count;

        public PerformanceEntry(String name) {
            this.name = name;
        }

        public void addDrawingTime(long nanos) {
            this.nanosSum += nanos;
            ++this.count;
        }

        public void reset() {
            this.count = 0;
            this.nanosSum = 0L;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class RuntimePerformanceWatch {
        int hwFullSpectrumRefreshes = 0;
        volatile long lastStatisticsRefreshed = System.currentTimeMillis();
        PerformanceEntry persisentDisplay = new PerformanceEntry("Pers.disp");
        PerformanceEntry waterfallUpdate = new PerformanceEntry("Wtrfall.upd");
        PerformanceEntry waterfallDraw = new PerformanceEntry("Wtrfll.drw");
        PerformanceEntry chartDrawing = new PerformanceEntry("Spectr.chart");
        PerformanceEntry spurFilter = new PerformanceEntry("Spur.fil");
        private ArrayList<PerformanceEntry> entries = new ArrayList();

        public RuntimePerformanceWatch() {
            this.entries.add(this.persisentDisplay);
            this.entries.add(this.waterfallUpdate);
            this.entries.add(this.waterfallDraw);
            this.entries.add(this.chartDrawing);
            this.entries.add(this.spurFilter);
        }

        public synchronized String generateStatistics() {
            long timeElapsed = System.currentTimeMillis() - this.lastStatisticsRefreshed;
            if (timeElapsed <= 0L) {
                timeElapsed = 1L;
            }
            StringBuilder b = new StringBuilder();
            long sumNanos = 0L;
            for (PerformanceEntry entry : this.entries) {
                sumNanos += entry.nanosSum;
                float callsPerSec = (float)entry.count / ((float)timeElapsed / 1000.0f);
                b.append(entry.name).append(String.format(" %3dms (%5.1f calls/s) \n", entry.nanosSum / 1000000L, Float.valueOf(callsPerSec)));
            }
            b.append(String.format("Total: %4dms draw time/s: ", sumNanos / 1000000L));
            return b.toString();
        }

        public synchronized void reset() {
            this.hwFullSpectrumRefreshes = 0;
            for (PerformanceEntry dataDrawingEntry : this.entries) {
                dataDrawingEntry.reset();
            }
            this.lastStatisticsRefreshed = System.currentTimeMillis();
        }
    }
}

