/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.objectclass;

import java.text.ParseException;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.parsers.OpenLdapSchemaParser;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.model.io.OpenLdapSchemaFileExporter;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.AbstractObjectClassEditorPage;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.Messages;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditor;
import org.apache.directory.studio.schemaeditor.view.widget.SchemaSourceViewer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ObjectClassEditorSourceCodePage
extends AbstractObjectClassEditorPage {
    public static final String ID = String.valueOf(ObjectClassEditor.ID) + "sourceCodePage";
    private SchemaSourceViewer schemaSourceViewer;
    private boolean canLeaveThePage = true;
    private ModifyListener schemaSourceViewerListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ObjectClassEditorSourceCodePage.this.canLeaveThePage = true;
            try {
                ((ObjectClassEditor)((Object)ObjectClassEditorSourceCodePage.this.getEditor())).setDirty(true);
                OpenLdapSchemaParser parser = new OpenLdapSchemaParser();
                parser.parse(ObjectClassEditorSourceCodePage.this.schemaSourceViewer.getTextWidget().getText());
                List objectclasses = parser.getObjectClasses();
                if (objectclasses.size() == 1) {
                    ObjectClassEditorSourceCodePage.this.updateObjectClass((ObjectClass)objectclasses.get(0));
                }
            }
            catch (ParseException parseException) {
                ObjectClassEditorSourceCodePage.this.canLeaveThePage = false;
            }
        }
    };

    public ObjectClassEditorSourceCodePage(ObjectClassEditor editor) {
        super(editor, ID, Messages.getString("ObjectClassEditorSourceCodePage.SourceCode"));
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        form.getBody().setLayout((Layout)layout);
        toolkit.paintBordersFor(form.getBody());
        this.schemaSourceViewer = new SchemaSourceViewer(form.getBody(), null, null, false, 2816);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 10;
        this.schemaSourceViewer.getTextWidget().setLayoutData((Object)gd);
        Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
        this.schemaSourceViewer.getTextWidget().setFont(font);
        Document document = new Document();
        this.schemaSourceViewer.setDocument((IDocument)document);
        this.fillInUiFields();
        this.addListeners();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, String.valueOf(PluginConstants.PLUGIN_ID) + "." + "object_class_editor");
    }

    @Override
    protected void addListeners() {
        if (this.schemaSourceViewer != null) {
            this.schemaSourceViewer.getTextWidget().addModifyListener(this.schemaSourceViewerListener);
        }
    }

    @Override
    protected void removeListeners() {
        if (this.schemaSourceViewer != null) {
            this.schemaSourceViewer.getTextWidget().removeModifyListener(this.schemaSourceViewerListener);
        }
    }

    @Override
    protected void fillInUiFields() {
        this.schemaSourceViewer.getDocument().set(OpenLdapSchemaFileExporter.toSourceCode(this.getModifiedObjectClass()));
    }

    public boolean canLeaveThePage() {
        return this.canLeaveThePage;
    }

    private void updateObjectClass(ObjectClass ocl) {
        ObjectClass modifiedObjectClass = this.getModifiedObjectClass();
        modifiedObjectClass.setDescription(ocl.getDescription());
        modifiedObjectClass.setMayAttributeTypeOids(ocl.getMayAttributeTypeOids());
        modifiedObjectClass.setMustAttributeTypeOids(ocl.getMustAttributeTypeOids());
        modifiedObjectClass.setNames(ocl.getNames());
        modifiedObjectClass.setObsolete(ocl.isObsolete());
        modifiedObjectClass.setOid(ocl.getOid());
        modifiedObjectClass.setSuperiorOids(ocl.getSuperiorOids());
        modifiedObjectClass.setType(ocl.getType());
    }
}

