/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller.actions;

import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.actions.Messages;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditor;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditor;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditor;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditorInput;
import org.apache.directory.studio.schemaeditor.view.wrappers.AttributeTypeWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.Folder;
import org.apache.directory.studio.schemaeditor.view.wrappers.ObjectClassWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaWrapper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenElementAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private TreeViewer viewer;

    public OpenElementAction(TreeViewer viewer) {
        super(Messages.getString("OpenElementAction.OpenAction"));
        this.setToolTipText(Messages.getString("OpenElementAction.OpenToolTip"));
        this.setId(PluginConstants.CMD_OPEN_ELEMENT);
        this.setActionDefinitionId(PluginConstants.CMD_OPEN_ELEMENT);
        this.setEnabled(false);
        this.viewer = viewer;
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.size() > 0) {
                    boolean enabled = true;
                    for (Object selectedItem : selection) {
                        if (selectedItem instanceof SchemaWrapper || selectedItem instanceof AttributeTypeWrapper || selectedItem instanceof ObjectClassWrapper) continue;
                        enabled = false;
                        break;
                    }
                    OpenElementAction.this.setEnabled(enabled);
                } else {
                    OpenElementAction.this.setEnabled(false);
                }
            }
        });
    }

    public void run() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        for (Object selectedItem : selection) {
            if (selectedItem instanceof AttributeTypeWrapper) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new AttributeTypeEditorInput(((AttributeTypeWrapper)selectedItem).getAttributeType()), AttributeTypeEditor.ID);
                }
                catch (PartInitException e) {
                    PluginUtils.logError(Messages.getString("OpenElementAction.ErrorOpeningEditor"), e);
                    ViewUtils.displayErrorMessageDialog(Messages.getString("OpenElementAction.Error"), Messages.getString("OpenElementAction.ErrorOpeningEditor"));
                }
                continue;
            }
            if (selectedItem instanceof ObjectClassWrapper) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new ObjectClassEditorInput(((ObjectClassWrapper)selectedItem).getObjectClass()), ObjectClassEditor.ID);
                }
                catch (PartInitException e) {
                    PluginUtils.logError(Messages.getString("OpenElementAction.ErrorOpeningEditor"), e);
                    ViewUtils.displayErrorMessageDialog(Messages.getString("OpenElementAction.Error"), Messages.getString("OpenElementAction.ErrorOpeningEditor"));
                }
                continue;
            }
            if (selectedItem instanceof SchemaWrapper) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new SchemaEditorInput(((SchemaWrapper)selectedItem).getSchema()), SchemaEditor.ID);
                }
                catch (PartInitException e) {
                    PluginUtils.logError(Messages.getString("OpenElementAction.ErrorOpeningEditor"), e);
                    ViewUtils.displayErrorMessageDialog(Messages.getString("OpenElementAction.Error"), Messages.getString("OpenElementAction.ErrorOpeningEditor"));
                }
                continue;
            }
            if (!(selectedItem instanceof Folder)) continue;
            this.viewer.setExpandedState(selectedItem, true);
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

